(function() {
	window.map = {};
	window.OL = {};
	window.icons = [];
	window.infoWindows = [];
	window.markerLayer = null;
	window.drawLayer = null;
	window.trackPlayLayer = null;
	window.Geocoder = {};
	window.LocalSearch = {};
	window.select = null;
	window.clickEvent = null;

	/**
	 * OpenLayers操作地图
	 */
	OL = {
		/**
		 * 全局变量
		 */
		CONSTANT : {
			CONTAINER : "map",
			CURRENT_MAP_TYPE : "openStreetMap",
			CURRENT_MAP_JIUPIAN : 0,
			DEFAULT_ZOOM : 1,
			MIN_ZOOM : 1,
			MAX_ZOOM : 20,
			DEFAULT_LAT : 0,
			DEFAULT_LNG : 0,
			BASEPATH : null
		},
		/**
		 * 初始化普通地图
		 */
		initCommonMap : function() {
			window.infoWindows = [];
			
			var view = this.getView();
			var interactions = ol.interaction.defaults().extend([
			    new ol.interaction.DragRotateAndZoom()
			]);
			map = new ol.Map({
				view : view,
//				layers : [ mapLayer ],
				target : 'map',
				interactions : interactions,
				loadTilesWhileAnimating : true,/* 在动画期间加载图块 */
				loadTilesWhileInteracting : true/* 在与地图交互时会加载图块 */
			});

			window.map = map;
			OL.event.addListener_singleclick();
			
			/*动态点扩散效果*/
//			var point_overlay = new ol.Overlay({
//				element: document.getElementById('css_animation'),
//				positioning: 'center-center',
//				//position: [9871995.0, 4344069.0],
//				stopEvent: false
//			});
//			map.addOverlay(point_overlay);
//			//point_overlay.setPosition(map.getView().getCenter());
//			//point_overlay.setPosition(point.getCoordinates());
		},
		/**
		 * 初始化地图（含操作控件）
		 */
		initOpenLayersMap : function() {
			OL.initCommonMap(); // 初始化普通地图
			// 添加控件
			OL.control.addAttributControl();
			OL.control.addScaleLineControl();
			OL.control.addFullScreenControl();
			OL.control.addThumbnailsControl();
			OL.control.addRotationControl();
			OL.control.addLayerSwitcherControl();
			
			// OL.tools.addDraw();
//			OL.addChangeView();//添加地图切换
			markerLayer = new ol.layer.Vector({
				source : new ol.source.Vector({
					features : []
				})
			});
			map.addLayer(markerLayer);//添加marker图层
			markerLayer.setVisible(true);
		},
		/**
		 * 初始化地图（含拖拽文件到地图）
		 */
		initHistoricalTrackMap : function() {
			OL.initOpenLayersMap(); // 初始化地图（含操作控件）
			var styleFunction = function(feature, resolution) {
				var featureStyleFunction = feature.getStyleFunction();
				if (featureStyleFunction) {
					return featureStyleFunction.call(feature, resolution);
				} else {
					return defaultStyle[feature.getGeometry().getType()];
				}
			};
			var dragAndDropInteraction = new ol.interaction.DragAndDrop({
				formatConstructors: [
//					ol.format.GPX,
//					ol.format.IGC,
//					ol.format.TopoJSON,
					ol.format.GeoJSON,
					ol.format.KML
				]
			});
			
			dragAndDropInteraction.on('addfeatures', function(event) {
				var vectorSource = new ol.source.Vector({
					features: event.features
				});
				map.addLayer(new ol.layer.Image({
					source: new ol.source.ImageVector({
				    	source: vectorSource,
				    	style: styleFunction
				    })
				}));
				map.getView().fit(vectorSource.getExtent(), map.getSize());
			});
			map.addInteraction(dragAndDropInteraction);
		},
		getView : function() {
			var view = new ol.View({
				center : ol.proj.transform([ this.CONSTANT.DEFAULT_LAT, this.CONSTANT.DEFAULT_LNG ], 'EPSG:4326', 'EPSG:3857'),
				// center : new ol.geom.Point([ this.CONSTANT.DEFAULT_LAT,this.CONSTANT.DEFAULT_LNG ]).transform('EPSG:4326', 'EPSG:3857').getCoordinates(),
				// center : [ 114.013351, 22.644093 ],
				zoom : this.CONSTANT.DEFAULT_ZOOM,
				minZoom: this.CONSTANT.MIN_ZOOM,
				maxZoom: this.CONSTANT.MAX_ZOOM
			});
			return view;
		},
		/**
		 * 视野自适应
		 */
		viewExtent : function(extent) {
			map.getView().fit(extent, map.getSize());
			if(map.getView().getZoom()>18){
				map.getView().setZoom(16);
			}
			map.renderSync();
		},
		/**
		 * 点越界处理
		 */
		ifOutBoundsPantoCenter : function(point){
			var extent = map.getView().calculateExtent(map.getSize());
			alert(ol.extent.containsCoordinate(extent, point.getCoordinates()));
			// 不在extent之内则做相应的处理
//			if(!ol.extent.containsCoordinate(extent, point.getCoordinates())){
			map.getView().fit(point, map.getSize());
//			if(map.getView().getZoom()<12){
				map.getView().setZoom(16);
//			}
//		    map.getView().setCenter(point.getCoordinates());
		       //map.render();
		    map.renderSync();
//		   }
		},
		/**
		 * 设置地图中心点
		 */
		setCenterAndZoom : function(point,zoom) {
			map.getView().setCenter(point.getCoordinates());
			if (zoom != null) {
				map.getView().setZoom(zoom);
			}
		    map.render();
		},
		/**
		 * 创建一个经纬度(坐标点)
		 */
		getPoint : function(lat, lng) {
			return new ol.geom.Point([ lng, lat ]).transform('EPSG:4326', 'EPSG:3857');
		},
		getCircleExtent : function(point, radius) {
			let drawCircle = new ol.geom.Circle(point.getCoordinates(), radius);
			return drawCircle.getExtent();
		},
		getPolygonExtent : function(points) {
			let polygon = new ol.geom.Polygon([points]);
			polygon = polygon.clone().transform('EPSG:4326', 'EPSG:3857');
			return polygon.getExtent();
		},
		/**
		 * 创建标记
		 */
		createIcon : function(iconPath,scaleSize) {
			var icon = new ol.style.Style({
				image : new ol.style.Icon({
					src : iconPath,
					//size: [36, 36],
					//opacity: 0.75,//透明度
					scale: scaleSize?scaleSize:1,//缩放比例尺
					anchor : [ 0.5, 0.95 ]//坐标偏移量
				})
			});
			return icon;
		},
		/**
		 * 查询标记图标
		 */
		findIcon : function(id) {
			for (var i = 0; i < icons.length; i++) {
				var icon = icons[i];
				if (icon.id == id) {
					return icon;
				}
			}
			return null;
		},
		/**
		 * 获取一个标记图标
		 */
		getIcon : function(id,iconPath,scale) {
			var icon = OL.findIcon(id);
			if (icon == null) {
				icon = OL.createIcon(iconPath,scale);
				icon.id = id;
				icons.push(icon);
			}
			return icon;
		},
		/**
		 * 查找标记
		 */
		findMarker : function(id) {
			if(markerLayer){
				var marker = markerLayer.getSource().getFeatureById(id);
				return marker;
			}
		},
		/**
		 * 获取一个标记
		 */
		getMarker : function(id, point, iconStyle) {
			var marker = OL.findMarker(id);
			if (marker != null) {
				if (point != null) {
					marker.setGeometry(point);
				}
				if (iconStyle != null) {
					marker.setStyle(iconStyle);
				}
			}else{
				marker = OL.createMarker(id, point, iconStyle);
			}
//			OL.viewExtent([point.getCoordinates()]);//视野自适应
			return marker;
		},
		/**
		 * 创建Marker标注
		 */
		createMarker : function(id, point, iconStyle) {
			var marker = new ol.Feature({
				geometry : point,
			});
			marker.setId(id);
			marker.setStyle(iconStyle);
			if (typeof markerLayer !== 'undefined') {
				markerLayer.getSource().addFeature(marker);
			}
			return marker;
		},
		/**
		 * 设置标记
		 */
		setMarker : function(id, point, iconStyle) {
			var marker = OL.findMarker(id);
			if (marker != null) {
				if (point != null) {
					marker.setGeometry(point);
				}
				if (iconStyle != null) {
					marker.setStyle(iconStyle);
				}
			}
//			OL.viewExtent([point.getCoordinates()]);//视野自适应
			return marker;
		},
		/**
		 * 移除一个标记
		 */
		removeMarke : function(id) {
			var marker = OL.findMarker(id);
			if (marker != null) {
				markerLayer.getSource().removeFeature(marker);
			}
		},
		/**
		 * 移除所有标记
		 */
		removeAllMarke : function() {
			markerLayer.getSource().clear();
		},
		findCircle : function(id) {
			if(markerLayer){
				var circle = markerLayer.getSource().getFeatureById(id);
				return circle;
			}
		},
		getCircle : function(id, point, radius) {
			var circle = OL.findCircle(id);
			if (circle != null) {
				if (point != null) {
					circle.getGeometry().setCenter(point.getCoordinates());
				}
				if (radius != null) {
					circle.getGeometry().setRadius(radius);
				}
			}else{
				circle = OL.createCircle(id, point, radius);
			}
			return circle;
		},
		isShowCircle : function(id, isShow) {
			var circle = OL.findCircle(id);
			if (isShow) {
				circle.setStyle(OL.circleStyle());
			}else{
				circle.setStyle(new ol.style.Style());
			}
		},
		setCircle : function(id, point, radius) {
			var circle = OL.findCircle(id);
			if (circle != null) {
				if (point != null) {
					circle.getGeometry().setCenter(point.getCoordinates());
				}
				if (radius != null) {
					circle.getGeometry().setRadius(radius);
				}
			}
			return circle;
		},
		circleStyle : function() {
			var circleStyle = new ol.style.Style({
	            image: new ol.style.Circle(),
	            fill: new ol.style.Fill({//填充色
	                color: 'rgba(91, 192, 222, 0.2)'
	            }),
	            stroke: new ol.style.Stroke({//边线颜色
	                color: '#5BC0DE',
	                width: 1
	            })
	        });
			return circleStyle;
		},
		/**
		 * 创建圆
		 */
		createCircle : function(id, point, radius) {
	        var circle = new ol.Feature({//创建一个圆
	            geometry: new ol.geom.Circle(point.getCoordinates(), radius)
	        });
	        circle.setId(id);
	        circle.setStyle(OL.circleStyle());
			if (typeof markerLayer !== 'undefined') {
				markerLayer.getSource().addFeature(circle);
			}
			return circle;
		},
		removeCircle : function(id) {
			var circle = OL.findCircle(id);
			if (circle != null) {
				markerLayer.getSource().removeFeature(circle);
			}
		},
		/**
		 * 获取一个信息窗体
		 */
		getInfoWindow : function(id, point, htmlContent) {
			var infoWindow = OL.findInfoWindow(id);
			if (infoWindow == null) {
				infoWindow = OL.createInfoWindow(id, point, htmlContent);
				infoWindow.id = id;
				infoWindows.push(infoWindow);
			}else{
				infoWindow = OL.setInfoWindow(id, point, htmlContent);
			}
			return infoWindow;
		},
		/**
		 * 设置信息窗体
		 */
		setInfoWindow : function(id, point, htmlContent) {
			var infoWindow = OL.findInfoWindow(id);
			if (infoWindow != null) {
				if (point != null) {
					infoWindow.setPosition(point.getCoordinates());
				}
				if (htmlContent != null) {
					var content = document.getElementById('popup-content-' + id);
					if(content != undefined){
						content.innerHTML = htmlContent;
					}
				}
				$("#r_"+id).find("#myTab a").click(function(e){
					e.preventDefault();
					$(this).tab("show");
				});
			}
			return infoWindow;
		},
		/**
		 * 查询信息窗体
		 */
		findInfoWindow : function(id) {
			for (var i = 0; i < infoWindows.length; i++) {
				var infoWindow = infoWindows[i];
				if (infoWindow.id == id) {
					return infoWindow;
				}
			}
			return null;
		},
		/**
		 * 创建信息窗体
		 */
		createInfoWindow : function(id, point, htmlContent) {
			var html = '<div id="popup-'+id+'" class="ol-popup" style="display:none;padding:0;">';
			html += '<a href="javascript:void(0)" id="popup-closer-'+id+'" class="ol-popup-closer"></a>';
			html += '<div id="popup-content-'+id+'">'+htmlContent+'</div>';
			html += '</div>';
			var viewport = map.getViewport();
			$(viewport).append(html);
			$("#popup-closer-" + id).click(function(even){
				$("#popup-" + id).hide();
			});
			var infoWindow = new ol.Overlay({
				element : document.getElementById('popup-' + id),
				autoPan: true,
				autoPanAnimation : {
					duration : 250
				}
			});

			map.addOverlay(infoWindow);
			infoWindow.setPosition(point.getCoordinates());
			// OL.listenTab();
			$("#r_"+id).find("#myTab a").click(function(e){
				e.preventDefault();
				$(this).tab("show");
			});
			return infoWindow;
		},


		/**
		 * 移除信息窗体
		 */
		removeInfoWindow : function(id) {
			for (var i = 0; i < infoWindows.length; i++) {
				var infoWindow = infoWindows[i];
				if (infoWindow.id == id) {
					// infoWindows[i].setVisible(false);
					// infoWindows[i].setMap(map);
					$("#popup-" + id).hide();
					break;
				}
			}
		},
		/**
		 * 移除所有信息窗体
		 */
		removeAllInfoWindow : function(isClear) {
			for (var i = 0; i < infoWindows.length; i++) {
				// infoWindows[i].setVisible(false);
				// infoWindows[i].setMap(map);
				$("#popup-" + infoWindows[i].id).hide();
			}
			if (isClear) {
				infoWindows = [];
			}
		}
	};

	/**
	 * 操作工具
	 */
	OL.tools = {
		/**
		 * 视野自适应
		 */
		viewExtent_layer : function(layer, zoom) {// 合适比例缩放居中
			try{
				map.getView().fit(layer.getSource().getExtent(), {
					duration: 500,//动画的持续时间,
					callback: function () {
						map.getView().setZoom(zoom || map.getSize());
					},
				});
			}catch(err){
				console.log("Field of view adaptive Exception!");
			}
		},
		location : function(lat, lng, zoom) {
			// 丝滑的定位到中心点
			map.getView().animate({
				center: new ol.geom.Point([ lng, lat ]).transform('EPSG:4326', 'EPSG:3857').getCoordinates(),
				zoom: zoom || 15, // 缩放级别
				rotation: undefined, // 缩放完成view视图旋转弧度
				duration: 1000 // 缩放持续时间，默认不需要设置
			});
		},
		/**
		 * 绘制过程
		 */
		addDrawInteraction : function(type) {
			if (drawVector != null) {
				map.removeLayer(drawVector);
			}
			if (draw != null) {
				map.removeInteraction(draw);
			}
			// 绘制工具
			draw = new ol.interaction.Draw({
				source : drawSource,
				type : type
			});
			map.addLayer(drawVector);
			map.addInteraction(draw);

		},
		/**
		 * 测量两点的距离
		 */
		distance : function(points) {
			var wgs84Sphere = new ol.Sphere(6378137);
			var sourceProj = map.getView().getProjection();
			var length = 0;
			for (var i = 0, ii = gis.length - 1; i < ii; ++i) {
				var c1 = ol.proj.transform(points[i], sourceProj, 'EPSG:4326');
				var c2 = ol.proj.transform(points[i + 1], sourceProj, 'EPSG:4326');
				length += wgs84Sphere.haversineDistance(c1, c2);
			}

			var output = 0;
			if (length > 100) {
				output = (Math.round(length / 1000 * 100) / 100) + ' ' + 'km';
			} else {
				output = (Math.round(length * 100) / 100) + ' ' + 'm';
			}
			return output;
			// return map.getDistance(pointA, pointB); // 获取两点距离
		},
		locationTrack:function (points){
			const coordinates = ol.proj.fromLonLat(points);
			moveMarker.getGeometry().setCoordinates(coordinates);
		},
		/**
		 * 轨迹回放
		 */
		trackPlay : function(points, iconPath) {
			if(trackPlayLayer != undefined){
				trackPlayLayer.getSource().clear();
			}
			var lineString = new ol.geom.LineString(points,'XY').transform('EPSG:4326', 'EPSG:3857');
			
			for(var i=0;i<lineString.length;i++){
				lineString[i].forEachSegment(function(start, end) {
			          var dx = end[0] - start[0];
			          var dy = end[1] - start[1];
			          var rotation = Math.atan2(dy, dx);
			          // arrows
			          styles.push(new Style({
			            geometry: new Point(end),
			            image: new Icon({
			              src: 'https://openlayers.org/en/latest/examples/data/arrow.png',
			              anchor: [0.75, 0.5],
			              rotateWithView: true,
			              rotation: -rotation
			            })
			          }));
			        });
				}
			
			points = lineString.getCoordinates();
			var routeLength = points.length;
			var styles = {
				'route' : new ol.style.Style({
					stroke : new ol.style.Stroke({
						width : 6,
						color : [ 0, 255, 0, 0.8 ]
					})
				}),
				'startIcon' : new ol.style.Style({
					image:new ol.style.Circle({
	                    radius:7,
	                    snapToPixel:false,
	                    fill:new ol.style.Fill({ color:'#30C0FF'}),
	                    stroke:new ol.style.Stroke({
	                        color:'white',
	                        width:1
	                    })
	                })
				}),
				'endIcon' : new ol.style.Style({
					image:new ol.style.Circle({
	                    radius:7,
	                    snapToPixel:false,
	                    fill:new ol.style.Fill({ color:'red'}),
	                    stroke:new ol.style.Stroke({
	                        color:'white',
	                        width:1
	                    })
	                })
				}),
				'moveIcon' : new ol.style.Style({
					image : new ol.style.Icon({
					    scale: 0.6,
						anchor : [ 0.5, 1 ],
						src : iconPath
					})
				})
			};
			// 轨迹图层
			var routeFeature = new ol.Feature({
				type : 'route',
				geometry : lineString
			});
			var startMarker = new ol.Feature({
				type : 'startIcon',
				geometry : new ol.geom.Point(points[0])
			});
			var endMarker = new ol.Feature({
				type : 'endIcon',
				geometry : new ol.geom.Point(points[routeLength - 1])
			});
			moveMarker = new ol.Feature({
				id:"moveIcon",
				type : 'moveIcon',
				geometry : new ol.geom.Point(points[0])
			});
			window.moveMarker = moveMarker;
			var playing = false;
			// var animating = false;
			var speed, index=0, pauseM, originTime, pauseTime;
//			var speedInput = document.getElementById('speed');
			var searchButton = document.getElementById('search');
			var playOrpauseButton = document.getElementById('playOrpause');
			
			trackPlayLayer = new ol.layer.Vector({
				source : new ol.source.Vector({
					features : [routeFeature, startMarker, endMarker, moveMarker]
//					features : [routeFeature, moveMarker]
				}),
				style : function(feature) {
					// if (animating && feature.get('type') === 'moveIcon') {
					// 	return null;
					// }
					return styles[feature.get('type')];
				}
			});

			map.addLayer(trackPlayLayer);
			let extent = new ol.extent.boundingExtent(points);
			OL.viewExtent(extent);
			$("#spinner").change(function() {
				speed = speedSpinner.spinner("value");
			})
			
			var moveFeature = function(event) {
				var vectorContext = event.vectorContext;
				if($("#playing").prop("checked")) {
					$("#size").val(parseInt($("#size").val()) + speed);
					index = Math.round($("#size").val() / 1000);
				}else {
					return;
				}
				if (index >= routeLength) {
					alert("Play finished!");
					$("#size").val(0);
					index = 0;
					stopAnimation(true);
					return;
				}
				document.getElementById("historicalTrackScroll").scrollTop = (index-1)*41;
				$("tr[name='historyData']").removeAttr("style");
				$("#historyData-"+(index+1)).css({ "background-color": "#6EABFF" });
				// let result = new ol.geom.Point(points[index]);
				window.currentPoint = new ol.geom.Point(points[index]);
				var feature = new ol.Feature(currentPoint);
				//OL.ifOutBoundsPantoCenter(currentPoint);
				vectorContext.drawFeature(feature, styles.moveIcon);
				map.render();
			};

			playOrpauseButton.onclick = function() {
				if (!$("#playing").prop("checked")) {
					searchButton.disabled=true;//按钮禁用
					playing = true;
					moveMarker.setGeometry(null);
					speed = speedSpinner.spinner("value");
					map.on('postcompose', moveFeature);
					map.render();
					$("#playing").attr("checked",!$("#playing").prop("checked"));
				} else {
					stopAnimation();
				}
			}
			function stopAnimation(isEnded) {
				searchButton.disabled=false;
				playing = false;
				moveMarker.setGeometry(currentPoint);
				map.un('postcompose', moveFeature);
				$("#playing").attr("checked",!$("#playing").prop("checked"));
			}
			// function stopAnimation(ended) {
			// 	searchButton.disabled=false;
			// 	animating = false;
			// 	playing = false;
			// 	var coord = ended ? points[routeLength - 1] : points[0];
			// 	(moveMarker.getGeometry()).setCoordinates(coord);
			// 	map.un('postcompose', moveFeature);
			// }
		},
		/**
		 * 添加/修改/拖动 点、线、多边形、圆 drawType:Point,LineString,Polygon,Circle
		 */
		addDraw : function(o_range,callback) {
			if(drawLayer != null){//清理缓存
				map.removeInteraction(select);
				//map.removeLayer(drawLayer);
				//map.renderSync();
				drawLayer.getSource().clear();
				drawLayer.getSource().refresh();//刷新
				//drawLayer.refresh({ force: true, active: true });//强制刷新
			}
			var o_circle = document.getElementById('Circle');
			// var o_radius = document.getElementById('Radius');
			var o_polygon = document.getElementById('Polygon');
			var o_modify = document.getElementById('Modify');
			var o_draw = document.getElementById('Draw');
			var o_clear = document.getElementById('Clear');

			var source = new ol.source.Vector({
				wrapX : false
			});
			var drawFeature = null;
			//{"type":"Circle","latlng":[{"lng":0.0,"lat":0.0}],"radius":1000}
			//Polygon|114.0213248,22.6446784;1000
			
			if(o_range.indexOf("|") != -1){
				var o_feature = o_range.split('|');
				if (o_feature[0] == "Polygon") {
					var points = new Array();
					var polygon_str = o_feature[1].split(';');
					for (var i = 0; i < polygon_str.length; i++) {
						points[i] = new Array();
						var point_str = polygon_str[i].split(',');
						for (var j = 0; j < point_str.length; j++) {
							points[i][j] = parseFloat(point_str[j]);
						}
					}
					var polygon = new ol.geom.Polygon([ points ]);
					polygon = polygon.clone().transform('EPSG:4326', 'EPSG:3857');
					drawFeature = new ol.Feature(polygon);
				} else if (o_feature[0] == "Circle") {
					var circle = o_feature[1].split(';');
					var latlng = circle[0].split(',');
					var point = new ol.geom.Point([ parseFloat(latlng[0]),
							parseFloat(latlng[1]) ]).transform('EPSG:4326', 'EPSG:3857');
					circleRadius.spinner("value", parseInt(circle[1]));
					var drawCircle = new ol.geom.Circle(point.getCoordinates(), parseInt(circle[1]));
					drawFeature = new ol.Feature(drawCircle);
				}
				source.addFeature(drawFeature);
			}else if(parent.isJSON(o_range)){
				var rangeObj = JSON.parse(o_range);
				if (rangeObj.type == "Polygon") {
					var points = new Array();
					var latlng = rangeObj.latlng;
					for (var i = 0; i < latlng.length; i++) {
						points[i] = new Array();
						points[i][0] = latlng[i].lng;
						points[i][1] = latlng[i].lat;
					}
					var polygon = new ol.geom.Polygon([ points ]);
					polygon = polygon.clone().transform('EPSG:4326', 'EPSG:3857');
					drawFeature = new ol.Feature(polygon);
				} else if (rangeObj.type == "Circle") {
					try {
						var latlng = rangeObj.latlng;
						var radius = rangeObj.radius;
						var point = new ol.geom.Point([ latlng[0].lng,
							latlng[0].lat ]).transform('EPSG:4326', 'EPSG:3857');
						circleRadius.spinner("value", radius);
						var drawCircle = new ol.geom.Circle(point.getCoordinates(), radius);
						drawFeature = new ol.Feature(drawCircle);
					} catch(err) {
						drawFeature = new ol.Feature(null);
					}
				}
				source.addFeature(drawFeature);
			}

			drawLayer = new ol.layer.Vector({
				source : source,
				style : new ol.style.Style({
					fill : new ol.style.Fill({
						color : 'rgba(255, 255, 255, 0.2)'
					}),
					stroke : new ol.style.Stroke({
						color : '#ff00ff',
						width : 2
					}),
					image : new ol.style.Circle({
						radius : 7,
						fill : new ol.style.Fill({
							color : '#ffcc33'
						})
					})
				})
			});
			map.addLayer(drawLayer);
			OL.tools.viewExtent_layer(drawLayer);
			var draw, modify, drag;
			draw = new ol.interaction.Draw({
				source : source,
				type : ('none')
			});

			select = new ol.interaction.Select({
				condition : ol.events.condition.click,
				wrapX : false
			});
			
			modify = new ol.interaction.Modify({
				//condition: ol.events.condition.pointerMove,//鼠标移到featur上起作用
				features : select.getFeatures(),
				deleteCondition : function(event) {
					return ol.events.condition.shiftKeyOnly(event)
							&& ol.events.condition.singleClick(event);
				}
			});

			drag = new ol.interaction.Translate({
				features : select.getFeatures(),
				cursor_ : 'pointer'
			});

			map.addInteraction(draw);
			map.addInteraction(select);
			map.addInteraction(modify);
			map.addInteraction(drag);
			draw.setActive(false);
			select.setActive(false);
			modify.setActive(false);
			drag.setActive(false);
			
			select.on('select', function(evt) {
				var selected = evt.selected;
			});

			modify.on('modifyend', function(evt) {
				evt.features.forEach(function(feature) {
					saveLatLngs(feature);
				});
			});
			drag.on('translateend', function(evt) {
				evt.features.forEach(function(feature) {
					saveLatLngs(feature);
				});
			});

			function saveLatLngs(feature) {
				var range = {};
				var latlng = new Array();
				var geometry = feature.getGeometry();
				var geometryType = geometry.getType();
				range.type = geometryType;
				if (geometryType == "Polygon") {
					var coordinates = geometry.getCoordinates()[0];
					for (var i = 0; i < coordinates.length; i++) {
						var coordinate = ol.proj.transform(coordinates[i],
								"EPSG:3857", "EPSG:4326");
						coordinate = ol.coordinate.format(coordinate, '{x},{y}', 6);
						var coo = coordinate.split(',');
						var point = {};
						point.lng = parseFloat(coo[0]);
						point.lat = parseFloat(coo[1]);
						latlng[i] = point;
					}
//					callback(points.substring(0, points.length - 1));
				} else if (geometryType == "Circle") {
					circleRadius.spinner("value", Math.round(geometry.getRadius()));
					var center = ol.proj.transform(geometry.getCenter(), "EPSG:3857", "EPSG:4326");
					center = ol.coordinate.format(center, '{x},{y}', 6);
					//callback("Circle|" + latlng + ";" + Math.round(geometry.getRadius()));
					var coo = center.split(',');
					var point = {};
					point.lng = parseFloat(coo[0]);
					point.lat = parseFloat(coo[1]);
					latlng[0] = point;
					range.radius = Math.round(geometry.getRadius());
				}
				range.latlng = latlng;
				callback(JSON.stringify(range));
			}

			o_circle.onclick = function() {
				draw.setActive(false);
				select.setActive(false);
				modify.setActive(false);
				drag.setActive(false);

				draw = new ol.interaction.Draw({
					source : source,
					type : 'Circle'
				});
				map.addInteraction(draw);
				draw.on('drawstart', function(evt) {
					clear();
				});
				draw.on('drawend', function(evt) {
					circleRadius.spinner("value", parseInt(evt.feature.getGeometry().getRadius()));
					saveLatLngs(evt.feature);
					draw.setActive(false);
					select.setActive(true);
					drag.setActive(true);
				});
			}
			$("#spinner").change(function() {
				var features = select.getFeatures().getArray();
				for (var i = 0; i < features.length; i++) {
					var geometry = features[i].getGeometry();
					var geometryType = geometry.getType();
					if (geometryType == "Circle") {
						var range = {};
						var latlng = new Array();
						range.type = "Circle";
						geometry.setRadius(circleRadius.spinner("value"));
						range.radius = Math.round(geometry.getRadius());
						var center = ol.proj.transform(geometry.getCenter(),
								"EPSG:3857", "EPSG:4326");
						center = ol.coordinate.format(center, '{x},{y}', 6);
						var coo = center.split(',');
						var point = {};
						point.lng = parseFloat(coo[0]);
						point.lat = parseFloat(coo[1]);
						latlng[0] = point;
						range.latlng = latlng;
						callback(JSON.stringify(range));
					}
				}
			});
			o_polygon.onclick = function() {
				draw.setActive(false);
				select.setActive(false);
				modify.setActive(false);
				drag.setActive(false);
				draw = new ol.interaction.Draw({
					source : source,
					type : 'Polygon',
					maxPoints: 8
				});
				map.addInteraction(draw);
				draw.on('drawstart', function(evt) {
					clear();
				});
				draw.on('drawend', function(evt) {
					saveLatLngs(evt.feature);
					draw.setActive(false);
					select.setActive(true);
					modify.setActive(true);
				});
			}
			o_modify.onclick = function() {
				draw.setActive(false);
				drag.setActive(false);
				select.setActive(true);
				modify.setActive(true);
			}
			o_draw.onclick = function() {
				draw.setActive(false);
				modify.setActive(false);
				select.setActive(true);
				drag.setActive(true);
			}
			o_clear.onclick = function() {
				clear();
			}
			function clear() {
				drawLayer.getSource().clear();
				if (select) {
					select.getFeatures().clear();
				}
				//o_range.innerHTML = "";
				callback("");
			}
		},
		/**
		 * 根据用户覆盖物的标识属性显示覆盖物
		 */
		showOverlay : function(properties, value) {
			var overlay = this.getOverlayByNodeId(properties, value);
			overlay.show();
		},
		/**
		 * 根据用户覆盖物的标识属性隐藏覆盖物
		 */
		hideOverlay : function(properties, value) {
			var overlay = this.getOverlayByNodeId(properties, value);
			overlay.hide();
		},
		/**
		 * 根据用户覆盖物的标识属性移除覆盖物
		 */
		removeOverlay : function(properties, value) {
			var overlay = this.getOverlayByNodeId(properties, value);
			if (overlay)
				map.removeOverlay(overlay);
		},
		/**
		 * 删除地图上所有覆盖物
		 */
		removeAllOverlays : function() {
			map.clearOverlays();
		}
//		,
//		asyncLoaded : function(url, callBack) {/* url为js的链接，callBack为回调函数 */
//			var script = document.createElement('script');
//			script.type = 'text/javascript';
//			/*
//			 * if else 这几句话必须要写到这位置处，不能放最后，因为if中js加载中script.readyState存在好几种状态，
//			 * 只有状态改变‘readystatechange’事件才会触发，但现在浏览器加载速度很快，当解析到该事件时JS有可能以加载完，
//			 * 所以事件根本不会触发，所以要写到前面
//			 */
//			if (script.readystate) {// 兼容IE
//				script.onreadystatechange = function() {// 状态改变事件才触发
//					if (script.readyState == 'loaded'
//							|| script.readyState == 'complete') {
//						callBack();
//						script.onreadystatechange = null;
//					}
//				}
//			} else { //Others: Firefox, Safari, Chrome, and Opera 
//				script.onload = function(e) {
//					callBack();
//				}
//			}
//			script.src = url;
//			document.body.appendChild(script);
//		}
	};

	// /**
	//  * 探索处理
	//  */
	// OL.search = {
	// 	/**
	// 	 * 本地探索（含自动提示）
	// 	 */
	// 	localSearch : function(latLngStr) {
	// 		var latLng = latLngStr.split(',');
	// 		var lng = parseFloat(latLng[0].trim());
	// 		var lat = parseFloat(latLng[1].trim());
	//
	// 		var icon = MapsUtil.getIcon("id-location","point1.png",1,true);
	// 		var point = OL.getPoint(lat, lng);
	// 		OL.getMarker("id-location", point, icon);
	// 		OL.tools.location(lat, lng);
	// 	}
	// };

	/**
	 * OpenLayers控件
	 */
	OL.control = {
		/**
		 * 添加属性控件
		 */
		addAttributControl : function() {
			map.addControl(new ol.control.Attribution());
		},
		/**
		 * 添加鼠标定位控件
		 */
		addMousePositionControl : function() {
			map.addControl(new ol.control.MousePosition({
			    undefinedHTML: 'outside',
			    projection: 'EPSG:4326', 
			    coordinateFormat: function(coordinate) {
			        return ol.coordinate.format(coordinate, '{x}, {y}', 6); 
			        }              
			    })
			);
		},
		/**
		 * 添加缩略图控件
		 */
		addThumbnailsControl : function() {
			map.addControl(new ol.control.OverviewMap({
			// collapsed : false
			}));
		},
		/**
		 * 添加旋转控件
		 */
		addRotationControl : function() {
			map.addControl(new ol.control.Rotate({
				autoHide : false
			}));
		},
		/**
		 * 添加比例尺控件
		 */
		addScaleLineControl : function() {
			map.addControl(new ol.control.ScaleLine());
		},
		/**
		 * 添加缩放控件
		 */
		addZoomControl : function() {
			map.addControl(new ol.control.Zoom());
		},
		/**
		 * 添加缩放滑动控件
		 */
		addZoomSliderControl : function() {
			map.addControl(new ol.control.ZoomSlider());
		},
		/**
		 * 添加缩放到当前视图滑动控件
		 */
		addZoomToExtentControl : function() {
			map.addControl(new ol.control.ZoomToExtent());
		},
		/**
		 * 添加全屏控件
		 */
		addFullScreenControl : function() {
			map.addControl(new ol.control.FullScreen());
		},
		/**
		 * 拖拽文件到地图,支持的格式包括 GeoJSON, GML, KML, GPX, OSMXML, TopoJSON 和 IGC
		 */
		addDragAndDropControl : function() {
//			var dragAndDropInteraction = new ol.interaction.DragAndDrop({
//				formatConstructors: [
//					ol.format.GeoJSON,
//					ol.format.KML
//					]
//			});
//			var interactions = ol.interaction.defaults().extend([
//			    new ol.interaction.DragRotateAndZoom(),
//			    dragAndDropInteraction
//			 ]);
//			dragAndDropInteraction.on('addfeatures', function(event){
//				alert("989898");
//			});
		},
		addLayerSwitcherControl : function() {
			map.addControl(new ol.control.LayerSwitcher());
		},
		/**
		 * 工具栏控件
		 */
		addToolBarControl : function(init_range, callback) {
			const location_id = "id-location";
			var source = new ol.source.Vector({
				wrapX : false
			});
			if(init_range != null){
				var drawFeature = null;
				var rangeObj = JSON.parse(init_range);
				if (rangeObj.type == "Polygon") {
					var points = new Array();
					var latlng = rangeObj.latlng;
					for (var i = 0; i < latlng.length; i++) {
						points[i] = new Array();
						points[i][0] = latlng[i].lng;
						points[i][1] = latlng[i].lat;
					}
					var polygon = new ol.geom.Polygon([ points ]);
					polygon = polygon.clone().transform('EPSG:4326', 'EPSG:3857');
					drawFeature = new ol.Feature(polygon);
				} else if (rangeObj.type == "Circle") {
					try {
						var latlng = rangeObj.latlng;
						var radius = rangeObj.radius;
						var point = new ol.geom.Point([ latlng[0].lng,
							latlng[0].lat ]).transform('EPSG:4326', 'EPSG:3857');
						var drawCircle = new ol.geom.Circle(point.getCoordinates(), radius);
						drawFeature = new ol.Feature(drawCircle);
					} catch(err) {
						drawFeature = new ol.Feature(null);
					}
				}
				source.addFeature(drawFeature);
			}

			drawLayer = new ol.layer.Vector({
				source : source,
				style : new ol.style.Style({
					fill : new ol.style.Fill({
						color : 'rgba(255, 255, 255, 0.2)'
					}),
					stroke : new ol.style.Stroke({
						color : '#ff00ff',
						width : 2
					}),
					image : new ol.style.Circle({
						radius : 7,
						fill : new ol.style.Fill({
							color : '#ffcc33'
						})
					})
				})
			});
			map.addLayer(drawLayer);
			// OL.tools.viewExtent_layer(drawLayer);
			var draw, modify, drag;
			draw = new ol.interaction.Draw({
				source : source,
				type : ('none')
			});

			select = new ol.interaction.Select({
				condition : ol.events.condition.click,
				wrapX : false
			});

			modify = new ol.interaction.Modify({
				//condition: ol.events.condition.pointerMove,//鼠标移到featur上起作用
				features : select.getFeatures(),
				deleteCondition : function(event) {
					return ol.events.condition.shiftKeyOnly(event)
						&& ol.events.condition.singleClick(event);
				}
			});

			drag = new ol.interaction.Translate({
				features : select.getFeatures(),
				cursor_ : 'pointer'
			});

			map.addInteraction(draw);
			map.addInteraction(select);
			map.addInteraction(modify);
			map.addInteraction(drag);
			draw.setActive(false);
			select.setActive(false);
			modify.setActive(false);
			drag.setActive(false);
			// 修改（编辑）事件
			modify.on('modifyend', function(evt) {
				evt.features.forEach(function(feature) {
					saveLatLngs(feature);
				});
			});
			// 拖动（移动）事件
			drag.on('translateend', function(evt) {
				evt.features.forEach(function(feature) {
					if (feature.getId() == location_id) {
						var coordinate = ol.proj.transform(feature.getGeometry().getCoordinates(),
							"EPSG:3857", "EPSG:4326");
						let latLngStr = ol.coordinate.format(coordinate, '{x},{y}', 6);
						document.getElementById("searchText").value = latLngStr;
					}
					saveLatLngs(feature);
				});
			});

			function clear() {
				ol.Observable.unByKey(clickEvent);
				mapText.setText("");
				drawLayer.getSource().clear();
				if (select) {
					select.getFeatures().clear();
				}
				if(callback != null){
					callback("");
				}
			}
			function saveLatLngs(feature) {
				var range = {};
				var latlng = new Array();
				var geometry = feature.getGeometry();
				var geometryType = geometry.getType();
				range.type = geometryType;
				if (geometryType == "LineString") {
					mapText.setText("Distance："+geometry.getLength().toFixed(2)+"m");
					draw.setActive(false);
				} else if (geometryType == "Polygon") {
					var coordinates = geometry.getCoordinates()[0];
					for (var i = 0; i < coordinates.length; i++) {
						var coordinate = ol.proj.transform(coordinates[i],
							"EPSG:3857", "EPSG:4326");
						coordinate = ol.coordinate.format(coordinate, '{x},{y}', 6);
						var coo = coordinate.split(',');
						var point = {};
						point.lng = parseFloat(coo[0]);
						point.lat = parseFloat(coo[1]);
						latlng[i] = point;
					}
				} else if (geometryType == "Circle") {
					var center = ol.proj.transform(geometry.getCenter(), "EPSG:3857", "EPSG:4326");
					center = ol.coordinate.format(center, '{x},{y}', 6);
					var coo = center.split(',');
					var point = {};
					point.lng = parseFloat(coo[0]);
					point.lat = parseFloat(coo[1]);
					latlng[0] = point;
					range.radius = Math.round(geometry.getRadius());
				}
				range.latlng = latlng;
				if(callback != null){
					callback(JSON.stringify(range));
				}
			}

			//初始化工具栏
			var mainBar = new ol.control.Bar();
			mainBar.setPosition('left-top');
			map.addControl(mainBar);

			var toolBar = new ol.control.Bar();
			mainBar.addControl(toolBar);
			//工具
			var toolBtn = new ol.control.Button({
				html: '<i class="icon-tools"></i>',
				title: "Tools",
				handleClick: function () {
					if(editBar.getVisible()) {
						editBar.setVisible(false);
						searchText.setVisible(false);
					}else {
						editBar.setVisible(true);
					}
				}
			});
			toolBar.addControl(toolBtn);

			var editBar = new ol.control.Bar({
				toggleOne: true,    // one control active at the same time
				group: false        // group controls together
			});
			mainBar.addControl(editBar);

			//搜索定位
			var searchText;
			var searchLocation = new ol.control.Button({
				html: '<i class="icon-search"></i>',
				title: "Search location",
				handleClick: function () {
					draw.setActive(false);
					select.setActive(false);
					modify.setActive(false);
					drag.setActive(false);
					//定位经纬度
					if (searchText == null) {
						searchText = new ol.control.Html({
							title: 'format:Lng,Lat + Enter',
							className: 'ol-control ol-searchText',
							html: '<input type="text" id="searchText" placeholder="format:Lng,Lat + Enter" value="" />',
							handleType: 'keydown',
							handleCallback: function (element, e) {
								let evt = window.event || e;
								if (evt.keyCode === 13) {
									let latLngStr = document.getElementById("searchText").value;
									let latLng = latLngStr.split(',');
									let lng = parseFloat(latLng[0].trim());
									let lat = parseFloat(latLng[1].trim());
									let point = OL.getPoint(lat, lng);
									let icon = new ol.style.Style({
										image: new ol.style.Circle({ // 圆形
											radius: 9, // 半径
											fill: new ol.style.Fill({color: 'red'}) // 填充色
										})
									});
									OL.getMarker(location_id, point, icon);
									OL.tools.location(lat, lng);
								}
							}
						});
						// 默认隐藏
						searchText.setVisible(false);
						map.addControl(searchText);
					}
					if (searchText.getVisible()) {
						searchText.setVisible(false);
					}else {
						searchText.setVisible(true);
					}
				}
			});
			editBar.addControl(searchLocation);

			//测经纬度
			var mapText = new ol.control.Text();
			map.addControl(mapText);
			var pointBtn = new ol.control.Button({
				html: '<i class="icon-target"></i>',
				title: "Measure lon&lat",
				handleClick: function () {
					clickEvent = map.on("click",function(evt){
						drawLayer.getSource().clear();
						if (select) {
							select.getFeatures().clear();
						}
						var latlng = ol.proj.transform(evt.coordinate, "EPSG:3857", "EPSG:4326");
						var latlngStr = ol.coordinate.format(latlng, '{x}, {y}', 6);
						mapText.setText(latlngStr);
					});
				}
			});
			editBar.addControl(pointBtn);
			//线测量
			var lineBtn = new ol.control.Button({
				html: '<i class="icon-linegraph"></i>',
				title: "Line",
				handleClick: function () {
					draw.setActive(false);
					select.setActive(false);
					modify.setActive(false);
					drag.setActive(false);
					draw = new ol.interaction.Draw({
						source: source,
						type: "LineString",
						maxPoints: 10
					});
					map.addInteraction(draw);
					draw.on("drawstart", function(evt) {
						clear();
					});
					draw.on("drawend", function(evt) {
						mapText.setText("Distance："+evt.feature.getGeometry().getLength().toFixed(2)+"m");
						draw.setActive(false);
					});
				}
			});
			editBar.addControl(lineBtn);
			// 画圆
			var circleBtn = new ol.control.Button({
				html: '<i class="icon-circle"></i>',
				title: "Circle",
				handleClick: function () {
					draw.setActive(false);
					select.setActive(false);
					modify.setActive(false);
					drag.setActive(false);

					draw = new ol.interaction.Draw({
						source : source,
						type : 'Circle'
					});
					map.addInteraction(draw);
					draw.on('drawstart', function(evt) {
						clear();
					});
					draw.on('drawend', function(evt) {
						saveLatLngs(evt.feature);
						draw.setActive(false);
						select.setActive(true);
						drag.setActive(true);
					});
				}
			});
			editBar.addControl(circleBtn);
			// 画多边形
			var polygonBtn = new ol.control.Button({
				html: '<i class="icon-square2"></i>',
				title: "Polygon",
				handleClick: function () {
					draw.setActive(false);
					select.setActive(false);
					modify.setActive(false);
					drag.setActive(false);
					draw = new ol.interaction.Draw({
						source : source,
						type : 'Polygon',
						maxPoints: 8
					});
					map.addInteraction(draw);
					draw.on('drawstart', function(evt) {
						clear();
					});
					draw.on('drawend', function(evt) {
						saveLatLngs(evt.feature);
						draw.setActive(false);
						select.setActive(true);
						modify.setActive(true);
					});
				}
			});
			editBar.addControl(polygonBtn);
			// 编辑
			var editBtn = new ol.control.Button({
				html: '<i class="icon-edit2"></i>',
				title: "Edit",
				handleClick: function () {
					draw.setActive(false);
					drag.setActive(false);
					select.setActive(true);
					modify.setActive(true);
				}
			});
			editBar.addControl(editBtn);
			// 移动
			var moveBtn = new ol.control.Button({
				html: '<i class="icon-move"></i>',
				title: "Move",
				handleClick: function () {
					draw.setActive(false);
					modify.setActive(false);
					select.setActive(true);
					drag.setActive(true);
				}
			});
			editBar.addControl(moveBtn);
			// 清空
			var clearBtn = new ol.control.Button({
				html: '<i class="icon-trash-o"></i>',
				title: "Clear",
				handleClick: function () {
					clear();
					OL.removeMarke(location_id);
				}
			});
			editBar.addControl(clearBtn);
		}
	};

	/**
	 * 地图事件
	 */
	OL.event = {
		addListener_singleclick : function() {// 响应单击事件
			window.map.on("click", function(e) {
				var feature = window.map.forEachFeatureAtPixel(e.pixel, function(
						feature, layer) {
					return feature;
				});
				if (feature) {
//					 alert("888=="+feature.getId()+"=="+feature.getGeometry());
					var point = feature.getGeometry();
					// OL.setInfoWindow(feature.get('id'),point,htmlContent);
					$("#popup-" + feature.getId()).show();
				}
			});
		},
		addListener_click : function(mapObject, callback) {// 响应点击事件
			var listener = mapObject.on('click', function(event) {
				callback();
			})
			return listener;
		},
		addListener_dblclick : function(mapObject, callback) {// 响应双击事件
			var listener = mapObject.on('dblclick', function(event) {
				callback();
			})
			return listener;
		},
		addListener_dmouseup : function(mapObject, callback) {// 鼠标按上
			mapObject.on('mouseup', function(event) {
				callback();
			});
		},
		addListener_mousedown : function(mapObject, callback) {// 鼠标按下
			mapObject.on('mousedown', function(event) {
				callback();
			});
		}

	};

})();