ol.control.LayerSwitcher = function(opt_options) {
	var this_ = this;
	var options = opt_options || {};
	
	var layers = new Array();
	if(window.parent.googleStatus == true){
		layers.push({"mapType":"googleMap","jiupian":"1","showText":"Google Map","layer":null});
		layers.push({"mapType":"googleMapSate","jiupian":"0","showText":"Google Sate Map","layer":null});
	}
	if(window.parent.baiduStatus == true){
		layers.push({"mapType":"baiduMap","jiupian":"2","showText":"Baidu Map","layer":null});
		layers.push({"mapType":"baiduMapSate","jiupian":"2","showText":"Baidu Sate Map","layer":null});
	}
	if(window.parent.gaodeStatus == true){
		layers.push({"mapType":"gaodeMap","jiupian":"1","showText":"Gaode Map","layer":null});
		layers.push({"mapType":"gaodeMapSate","jiupian":"1","showText":"Gaode Sate Map","layer":null});
	}
	layers.push({"mapType":"openStreetMap","jiupian":"0","showText":"OpenStreetMap","layer":null});
	for(var i=0;i<layers.length; i++){
		var maplayer = this_.getLayer(layers[i].mapType);
		layers[i].layer = maplayer;
		map.addLayer(maplayer);
	}
	
	
    this.shownClassName = 'shown';
    
	var element = document.createElement('div');
    element.className = 'ol-unselectable ol-control layer-switcher';

    var layer_select = document.createElement('div');
    element.appendChild(layer_select);
    
    this.select_text = document.createElement('span');
    this.select_text.className = 'selected';
    layer_select.appendChild(this.select_text);
    var arrow = document.createElement('span');
    arrow.className = 'arrow';
    layer_select.appendChild(arrow);
    
    var ul = document.createElement('ul');
    element.appendChild(ul);
    for (var i = 0; i < layers.length; i++) {
    	var li = document.createElement('li');
    	li.setAttribute('mapType', layers[i].mapType);
    	li.innerHTML = layers[i].showText;
    	li.onclick = function() {
    		this_.selectLayer(layers,this.getAttribute('mapType'));
    		ul.classList.remove('shown');
    	};
    	li.onmouseover = function(e) {
    		this.classList.add("hover");
        };
        li.onmouseout = function(e) {
        	this.classList.remove("hover");
        };
    	ul.appendChild(li);
    }
    layer_select.onclick = function() {
    	if (!ul.classList.contains('shown')) {
 			ul.classList.add('shown');
		}else{
			ul.classList.remove('shown');
		}
    };
	
    this_.selectLayer(layers,OL.CONSTANT.CURRENT_MAP_TYPE);//默认开启
	
//	function selectLayer(layerName) {
//		for (var i = 0; i < layers.length; i++) {
////			alert("layerName="+layerName+"="+layers[i].name);
//			layers[i].layer.setVisible(layers[i].mapType === layerName);
//			if(layers[i].mapType === layerName){
//				select_text.innerHTML = layers[i].showText;
//				OL.CONSTANT.CURRENT_MAP_TYPE = layers[i].mapType.replace("Sate","");
//				OL.CONSTANT.CURRENT_MAP_JIUPIAN = layers[i].jiupian;
//			}
//		}
//	}
    
    
//    element.onmouseover = function(e) {
//        this_.showPanel();
//    };

//    element.onmouseout = function(e) {
//        e = e || window.event;
//        if (!element.contains(e.toElement)) {
//            this_.hidePanel();
//        }
//    };
    
    ol.control.Control.call(this, {
        element: element
//        target: options.target
    });

};

ol.inherits(ol.control.LayerSwitcher, ol.control.Control);

ol.control.LayerSwitcher.prototype.showPanel = function() {
	if (!this.element.lastChild.classList.contains(this.shownClassName)) {
		this.element.lastChild.classList.add(this.shownClassName);
	}
};

ol.control.LayerSwitcher.prototype.hidePanel = function() {
	if (this.element.lastChild.classList.contains(this.shownClassName)) {
		this.element.lastChild.classList.remove(this.shownClassName);
	}
};

ol.control.LayerSwitcher.prototype.selectLayer = function(layers,layerName) {
	for (var i = 0; i < layers.length; i++) {
		layers[i].layer.setVisible(layers[i].mapType === layerName);
		if(layers[i].mapType === layerName){
			this.select_text.innerHTML = layers[i].showText;
			OL.CONSTANT.CURRENT_MAP_TYPE = layers[i].mapType.replace("Sate","");
			OL.CONSTANT.CURRENT_MAP_JIUPIAN = layers[i].jiupian;
		}
	}
};

ol.control.LayerSwitcher.prototype.getLayer = function(mapType) {
	var source;
	if (mapType === 'openStreetMap') {// Open Street Map 地图层
		source = new ol.source.XYZ({
			url: 'http://{a-c}.tile.openstreetmap.org/{z}/{x}/{y}.png',
			attributions : [
				'Map data &copy; <a href="http://www.openstreetmap.org" target="_blank">OpenStreetMap</a>'
			]
		})
//		source = new ol.source.OSM({
//			attributions : [
//				new ol.Attribution({html: 'Map data &copy;2017'}),
//				new ol.Attribution({html : '<a href="http://www.openstreetmap.org" target="_blank">OpenStreetMap</a>'})
//			]
//		})
	} else if (mapType === 'gaodeMap' || mapType === 'gaodeMapSate') {// 高德地图层
		var url;
		if(mapType == 'gaodeMap'){
			// 老版地址
			// url = "http://webrd0{1-4}.is.autonavi.com/appmaptile?size=1&scale=1&style=7&x={x}&y={y}&z={z}";
			// 新版地址
			url = "http://wprd0{1-4}.is.autonavi.com/appmaptile?x={x}&y={y}&z={z}&lang=zh_cn&size=1&scl=1&style=7";
		}else if(mapType == 'gaodeMapSate'){
			// 老版地址
			// url = "http://webst0{1-4}.is.autonavi.com/appmaptile?style=6&x={x}&y={y}&z={z}";
			// 新版地址
			url = "http://wprd0{1-4}.is.autonavi.com/appmaptile?x={x}&y={y}&z={z}&size=1&scl=1&style=6";
		}
		source = new ol.source.XYZ({
			url : url,
			attributions : [
				'Map data &copy; <a href="http://ditu.amap.com/" target="_blank">高德地图</a>'
			]
		})
	} else if (mapType === 'googleMap' || mapType === 'googleMapSate') {// google地图层
		//var url = 'http://mt{0-4}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}?hl='+locale;
		var url = '';
		if(mapType == 'googleMap'){
			url = 'http://mt{0-3}.google.com/vt/lyrs=m&x={x}&y={y}&z={z}';
		}else if(mapType == 'googleMapSate'){
			url = 'http://mt{0-3}.google.com/vt/lyrs=y&x={x}&y={y}&z={z}';
		}
		source = new ol.source.XYZ({
			url: url,
			attributions : [
				'Map data &copy; <a href="https://maps.google.com/maps" target="_blank">Google Map</a>'
			]
		})
	} else if (mapType === 'baiduMap' || mapType === 'baiduMapSate') {// 百度地图层
		var projection = ol.proj.get("EPSG:3857");
		var resolutions = [];
		for (var i = 0; i < 19; i++) {
			resolutions[i] = Math.pow(2, 18 - i);
		}
		var tilegrid = new ol.tilegrid.TileGrid({
//			origin : [ 0,0 ],
			origin : [ -110,16600 ],
			resolutions : resolutions
		});
		var source = new ol.source.TileImage({
			projection : projection,
			tileGrid : tilegrid,
			crossOrigin: 'anonymous',   //跨域
			tileUrlFunction : function(tileCoord, pixelRatio, proj){
				if (!tileCoord) {
					return "";
				}
				var z = tileCoord[0];
				var x = tileCoord[1];
				var y = tileCoord[2];

				if (x < 0) {
					x = "M" + (-x);
				}
				if (y < 0) {
					y = "M" + (-y);
				}
				if(mapType == 'baiduMap'){
					return "http://online3.map.bdimg.com/onlinelabel/?qt=tile&x="+x+"&y="+y+"&z="+z+"&styles=pl&udt=20170301&scaler=1&p=1";
				}else if(mapType == 'baiduMapSate'){
					return "http://shangetu3.map.bdimg.com/it/u=x="+x+";y="+y+";z="+z+";v=009;type=sate&fm=46&udt=20170301";
				}
			},
			attributions : [
				'Map data &copy; <a href="http://map.baidu.com" target="_blank">Baidu Map</a>'
			]
		});
	}
	var layer = new ol.layer.Tile({
		visible: false,//不可见
		source : source
	});
	return layer;
};
