/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.swing;

import freeseawind.swing.LuckScrollPane;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;

public class LuckScrollPaneLayout
extends ScrollPaneLayout {
    private static final long serialVersionUID = 8125767787388625029L;
    protected JLayeredPane layerPane;

    @Override
    public void layoutContainer(Container parent) {
        JScrollPane scrollPane = (JScrollPane)parent;
        Rectangle availR = scrollPane.getBounds();
        availR.y = 0;
        availR.x = 0;
        Insets insets = parent.getInsets();
        availR.x = insets.left;
        availR.y = insets.top;
        availR.width -= insets.left + insets.right;
        availR.height -= insets.top + insets.bottom;
        int x = insets.left;
        int y = insets.top;
        int width = availR.width - insets.left + insets.right;
        int height = availR.height - insets.top + insets.bottom;
        super.layoutContainer(parent);
        if (scrollPane.getRowHeader() != null) {
            int rowHeaderW = scrollPane.getRowHeader().getWidth();
            int rowHeaderH = height;
            int startY = y;
            if (this.upperLeft != null) {
                startY += this.upperLeft.getHeight();
                rowHeaderH -= this.upperLeft.getHeight();
            }
            if (this.lowerLeft != null) {
                rowHeaderH -= this.lowerLeft.getHeight();
            }
            scrollPane.getRowHeader().setBounds(x, startY, rowHeaderW, rowHeaderH);
            x += scrollPane.getRowHeader().getSize().width;
        }
        if (scrollPane.getColumnHeader() != null) {
            int columnHeaderW = width;
            int columnHeaderH = scrollPane.getColumnHeader().getSize().height;
            if (this.upperLeft != null) {
                columnHeaderW -= this.upperLeft.getWidth();
            }
            if (this.upperRight != null) {
                columnHeaderW -= this.upperRight.getWidth();
            }
            scrollPane.getColumnHeader().setBounds(x, y, columnHeaderW, columnHeaderH);
            y += scrollPane.getColumnHeader().getSize().height;
        }
        this.layerPane.setBounds(0, 0, width, height);
        if (this.viewport != null) {
            this.viewport.setBounds(x, y, width, height);
        }
    }

    @Override
    public void syncWithScrollPane(JScrollPane sp) {
        super.syncWithScrollPane(sp);
        if (sp instanceof LuckScrollPane) {
            this.layerPane = ((LuckScrollPane)sp).getLayeredPane();
        }
    }
}

