/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.swing;

import freeseawind.swing.LuckScrollPaneLayout;
import java.awt.Component;
import javax.swing.JLayeredPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;

public class LuckScrollPane
extends JScrollPane {
    protected JLayeredPane layeredPane;
    private static final long serialVersionUID = -9008522455170803317L;

    public LuckScrollPane() {
        this(null, 20, 30);
    }

    public LuckScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.setLayout(new LuckScrollPaneLayout());
        if (view instanceof JTable) {
            this.setColumnHeaderView(((JTable)view).getTableHeader());
        }
    }

    public LuckScrollPane(Component view) {
        this(view, 20, 30);
    }

    public LuckScrollPane(int vsbPolicy, int hsbPolicy) {
        this(null, vsbPolicy, hsbPolicy);
    }

    @Override
    public void setViewport(JViewport viewport) {
        this.createLayeredPane();
        JViewport old = this.getViewport();
        this.viewport = viewport;
        if (viewport != null) {
            this.layeredPane.add((Component)viewport, JLayeredPane.FRAME_CONTENT_LAYER);
        } else if (old != null) {
            this.layeredPane.remove(old);
        }
        this.firePropertyChange("viewport", old, viewport);
        if (this.accessibleContext != null) {
            ((JScrollPane.AccessibleJScrollPane)this.accessibleContext).resetViewPort();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setVerticalScrollBar(JScrollBar verticalScrollBar) {
        this.createLayeredPane();
        JScrollBar old = this.getVerticalScrollBar();
        this.verticalScrollBar = verticalScrollBar;
        if (verticalScrollBar != null) {
            verticalScrollBar.setOpaque(false);
            this.layeredPane.add((Component)verticalScrollBar, JLayeredPane.POPUP_LAYER);
        } else if (old != null) {
            this.layeredPane.remove(old);
        }
        this.firePropertyChange("verticalScrollBar", old, verticalScrollBar);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setHorizontalScrollBar(JScrollBar horizontalScrollBar) {
        this.createLayeredPane();
        JScrollBar old = this.getHorizontalScrollBar();
        this.horizontalScrollBar = horizontalScrollBar;
        if (horizontalScrollBar != null) {
            horizontalScrollBar.setOpaque(false);
            this.layeredPane.add((Component)horizontalScrollBar, JLayeredPane.POPUP_LAYER);
        } else if (old != null) {
            this.layeredPane.remove(old);
        }
        this.firePropertyChange("horizontalScrollBar", old, horizontalScrollBar);
        this.revalidate();
        this.repaint();
    }

    protected void createLayeredPane() {
        if (this.layeredPane == null) {
            this.layeredPane = new JLayeredPane();
            this.layeredPane.setName(this.getName() + ".layeredPane");
            this.add((Component)this.layeredPane, -1);
        }
    }

    public JLayeredPane getLayeredPane() {
        return this.layeredPane;
    }
}

