/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.swing;

import freeseawind.swing.JdkVersion;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LuckPopupFactory
extends PopupFactory {
    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        Popup popup = super.getPopup(owner, contents, x, y);
        Window obj = SwingUtilities.getWindowAncestor(contents);
        if (obj instanceof JWindow) {
            boolean isCompatible;
            JWindow window = (JWindow)obj;
            window.setBackground(UIManager.getColor("translucent.color"));
            ((JComponent)window.getContentPane()).setOpaque(false);
            JdkVersion version = JdkVersion.getSingleton();
            boolean bl = isCompatible = version.getMajor() <= 1 && version.getMinor() < 8;
            if (contents instanceof JPopupMenu && isCompatible) {
                boolean isFound = false;
                for (ComponentListener listener : window.getComponentListeners()) {
                    if (!(listener instanceof LuckPopupComponentListener)) continue;
                    isFound = true;
                    break;
                }
                if (!isFound) {
                    window.addComponentListener(new LuckPopupComponentListener());
                }
            }
        }
        return popup;
    }

    class LuckPopupComponentListener
    extends ComponentAdapter {
        LuckPopupComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            Object obj = e.getSource();
            if (obj instanceof JWindow) {
                JWindow window = (JWindow)obj;
                window.repaint();
            }
        }
    }
}

