/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.swing;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdkVersion {
    private String version = System.getProperty("java.version");
    private int major;
    private int minor;
    private int revision;
    private int num;
    private static final JdkVersion singleton = new JdkVersion();

    private JdkVersion() {
        Pattern p = Pattern.compile("\\d{1,}");
        Matcher m = p.matcher(this.version);
        LinkedList<Integer> list = new LinkedList<Integer>();
        while (m.find()) {
            String key = this.version.substring(m.start(), m.end()).toLowerCase().trim();
            list.add(Integer.parseInt(key));
        }
        this.major = this.getVersionInfo(list, 0);
        this.minor = this.getVersionInfo(list, 1);
        this.revision = this.getVersionInfo(list, 2);
        this.num = this.getVersionInfo(list, 3);
    }

    public static JdkVersion getSingleton() {
        return singleton;
    }

    private int getVersionInfo(List<Integer> list, int idx) {
        if (idx < list.size()) {
            return list.get(idx);
        }
        return 0;
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getNum() {
        return this.num;
    }

    public String toString() {
        return "JdkVersion [version=" + this.version + ", major=" + this.major + ", minor=" + this.minor + ", revision=" + this.revision + ", num=" + this.num + "]";
    }
}

