/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.geom;

import freeseawind.lf.geom.LuckProperty;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class LuckRectangle {
    private LuckProperty<Integer> startxProp;
    private LuckProperty<Integer> startyProp;
    private LuckProperty<Integer> heightProp;
    private LuckProperty<Integer> widthProp;
    private Rectangle rect;
    private JComponent parent;

    public LuckRectangle(JComponent parent) {
        this(new LuckProperty<Integer>(0), new LuckProperty<Integer>(0), new LuckProperty<Integer>(0), new LuckProperty<Integer>(0), parent);
    }

    public LuckRectangle(LuckProperty<Integer> startxProp, LuckProperty<Integer> startyProp, LuckProperty<Integer> widthProp, LuckProperty<Integer> heightProp, JComponent parent) {
        this.startxProp = startxProp;
        this.startyProp = startyProp;
        this.heightProp = heightProp;
        this.widthProp = widthProp;
        this.parent = parent;
        int x = startxProp.getField();
        int y = startyProp.getField();
        int w = widthProp.getField();
        int h = heightProp.getField();
        this.rect = new Rectangle(x, y, w, h);
    }

    public void updateFrame(int startX, int startY, int height, int width) {
        this.updateProp(this.startxProp, startX);
        this.updateProp(this.startyProp, startY);
        this.updateProp(this.heightProp, height);
        this.updateProp(this.widthProp, width);
        this.updateLocation();
        this.updateDeimension(height, width);
    }

    public void updateDeimension(int height, int width) {
        this.updateProp(this.heightProp, height);
        this.updateProp(this.widthProp, width);
        this.updateDimension();
    }

    public void updateLocation(int startX, int startY) {
        this.updateProp(this.startxProp, startX);
        this.updateProp(this.startyProp, startY);
        this.updateLocation();
    }

    public boolean contains(Point point) {
        this.rect.setFrame(this.getStartX(), this.getStartY(), this.getWidth(), this.getHeight());
        return this.rect.contains(point);
    }

    private void updateProp(LuckProperty<Integer> prop, int val) {
        if (prop.getType() != LuckProperty.LuckPropertyType.BINDPARENT) {
            prop.setField(val);
        }
    }

    private void updateLocation() {
        if (this.startxProp.getType() != LuckProperty.LuckPropertyType.BINDPARENT) {
            this.rect.x = this.getStartX();
        }
        if (this.startyProp.getType() != LuckProperty.LuckPropertyType.BINDPARENT) {
            this.rect.y = this.getStartX();
        }
    }

    private void updateDimension() {
        if (this.heightProp.getType() != LuckProperty.LuckPropertyType.BINDPARENT) {
            this.rect.width = this.getWidth();
        }
        if (this.widthProp.getType() != LuckProperty.LuckPropertyType.BINDPARENT) {
            this.rect.height = this.getHeight();
        }
    }

    public int getStartX() {
        if (this.startxProp.getType() == LuckProperty.LuckPropertyType.BINDPARENT) {
            return this.parent.getInsets().left;
        }
        return this.startxProp.getField();
    }

    public int getStartY() {
        if (this.startyProp.getType() == LuckProperty.LuckPropertyType.BINDPARENT) {
            return this.parent.getInsets().top;
        }
        return this.startyProp.getField();
    }

    public int getHeight() {
        if (this.heightProp.getType() == LuckProperty.LuckPropertyType.BINDPARENT) {
            return this.parent.getHeight();
        }
        return this.heightProp.getField();
    }

    public int getWidth() {
        if (this.widthProp.getType() == LuckProperty.LuckPropertyType.BINDPARENT) {
            return this.parent.getWidth();
        }
        return this.widthProp.getField();
    }
}

