/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.event;

import freeseawind.lf.basic.rootpane.LuckTitlePanel;
import freeseawind.lf.utils.LuckWindowUtil;
import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class WindowPropertyListener
implements PropertyChangeListener {
    private LuckTitlePanel titlePanel;

    public WindowPropertyListener(LuckTitlePanel titlePanel) {
        this.titlePanel = titlePanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Window window = (Window)evt.getSource();
        if ("title".equals(name)) {
            this.handleTitleEvent(window);
            return;
        }
        if ("iconImage".equals(name)) {
            this.handleIconEvent(window);
            return;
        }
        if ("resizable".equals(name)) {
            this.handleResizableEvent(window);
            return;
        }
        if ("componentOrientation".equals(name)) {
            this.handleComponetOrientation(window);
            return;
        }
    }

    protected void handleTitleEvent(Window window) {
        String newTitle = LuckWindowUtil.getWindowTitle(window);
        this.titlePanel.setTitle(newTitle);
    }

    protected void handleIconEvent(Window window) {
        Image newImage = LuckWindowUtil.getWindowImage(window);
        this.titlePanel.setIcon(new ImageIcon(newImage));
    }

    protected void handleResizableEvent(Window window) {
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            this.titlePanel.setResizeable(frame.isResizable());
        }
    }

    protected void handleComponetOrientation(Window window) {
        this.titlePanel.revalidate();
        this.titlePanel.repaint();
    }
}

