/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.event;

import freeseawind.lf.geom.LuckProperty;
import freeseawind.lf.geom.LuckRectangle;
import freeseawind.lf.utils.LuckWindowUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;

public class WindowMouseHandler
implements MouseInputListener {
    private boolean isMovingWindow;
    private int dragOffsetX;
    private int dragOffsetY;
    private int dragWidth;
    private int dragHeight;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private LuckRectangle dragArea;
    private LuckRectangle titleArea;
    private int dragCursor;

    public WindowMouseHandler(JComponent parent) {
        int titleHeight = UIManager.getInt("TitlePanel.height");
        LuckProperty<Integer> startxProp = new LuckProperty<Integer>(0);
        LuckProperty<Integer> startyProp = new LuckProperty<Integer>(0);
        LuckProperty<Integer> widthProp = new LuckProperty<Integer>(0);
        LuckProperty<Integer> heightProp = new LuckProperty<Integer>(LuckProperty.LuckPropertyType.FIX, titleHeight);
        this.dragArea = this.titleArea = new LuckRectangle(startxProp, startyProp, widthProp, heightProp, parent);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Window window = (Window)e.getSource();
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)window;
            JRootPane root = frame.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            if (!this.titleArea.contains(e.getPoint())) {
                return;
            }
            if (e.getClickCount() % 2 == 0 && (e.getModifiers() & 0x10) != 0) {
                int state = frame.getExtendedState();
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        frame.setExtendedState(state & 0xFFFFFFF9);
                    } else {
                        frame.setExtendedState(state | 6);
                    }
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Window window = (Window)e.getSource();
        JRootPane root = LuckWindowUtil.getRootPane(window);
        if (root == null || root.getWindowDecorationStyle() == 0) {
            return;
        }
        if (window != null) {
            window.toFront();
        }
        if (this.dragArea.contains(e.getPoint()) && this.dragCursor == 0) {
            JFrame frame;
            if (window instanceof JFrame && (frame = (JFrame)window).getExtendedState() == 6) {
                return;
            }
            this.isMovingWindow = true;
            this.dragOffsetX = e.getPoint().x;
            this.dragOffsetY = e.getPoint().y;
        } else if (LuckWindowUtil.isResizable(window)) {
            this.dragOffsetX = e.getPoint().x;
            this.dragOffsetY = e.getPoint().y;
            this.dragWidth = window.getWidth();
            this.dragHeight = window.getHeight();
            JRootPane rootPane = LuckWindowUtil.getRootPane(window);
            if (rootPane != null && LuckWindowUtil.isResizable(window)) {
                this.dragCursor = this.getCursor(this.dragWidth, this.dragHeight, e.getPoint(), rootPane.getInsets());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Window window = (Window)e.getSource();
        if (this.dragCursor != 0 && window != null && !window.isValid()) {
            window.validate();
            if (window instanceof JFrame) {
                ((JFrame)window).getRootPane().repaint();
            }
        }
        this.isMovingWindow = false;
        this.dragCursor = 0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Window window = (Window)e.getSource();
        int w = window.getWidth();
        int h = window.getHeight();
        Point point = e.getPoint();
        JRootPane rootPane = LuckWindowUtil.getRootPane(window);
        int cursor = 0;
        if (rootPane != null && LuckWindowUtil.isResizable(window)) {
            cursor = this.getCursor(w, h, point, rootPane.getInsets());
        }
        if (cursor != 0) {
            window.setCursor(Cursor.getPredefinedCursor(cursor));
        } else {
            window.setCursor(this.lastCursor);
        }
        this.dragCursor = cursor;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Window w = (Window)e.getSource();
        w.setCursor(this.lastCursor);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Window w = (Window)e.getSource();
        if (this.isMovingWindow) {
            Point prePoint = e.getLocationOnScreen();
            w.setLocation(prePoint.x - this.dragOffsetX, prePoint.y - this.dragOffsetY);
        } else if (this.dragCursor != 0) {
            this.updateBound(e.getPoint(), w);
        }
    }

    public int getCursor(int w, int h, Point point, Insets inset) {
        int radius = -1;
        int startX = inset.left + radius;
        int endX = w - inset.right + radius;
        int startY = inset.top + radius;
        int endY = h - inset.bottom + radius;
        if (point.x <= startX && point.y <= startY) {
            return 6;
        }
        if (point.x >= endX && point.y <= startY) {
            return 7;
        }
        if (point.x <= startX && point.y >= endY) {
            return 4;
        }
        if (point.x >= endX && point.y >= endY) {
            return 5;
        }
        if (point.x <= startX && point.y > startY && point.y < endY) {
            return 10;
        }
        if (point.y <= startY && point.x > startX && point.x < endX) {
            return 8;
        }
        if (point.x >= endX && point.y > startY && point.y < endY) {
            return 11;
        }
        if (point.y >= endY && point.x > startX && point.x < endX) {
            return 9;
        }
        return 0;
    }

    public void updateBound(Point pt, Window w) {
        Rectangle r = w.getBounds();
        Rectangle startBounds = new Rectangle(r);
        Dimension min = w.getMinimumSize();
        switch (this.dragCursor) {
            case 11: {
                this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                break;
            }
            case 9: {
                this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                break;
            }
            case 8: {
                this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                break;
            }
            case 10: {
                this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                break;
            }
            case 7: {
                this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                break;
            }
            case 5: {
                this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                break;
            }
            case 6: {
                this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                break;
            }
            case 4: {
                this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                break;
            }
        }
        if (!r.equals(startBounds)) {
            w.setBounds(r);
            if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                w.validate();
                w.repaint();
            }
        }
    }

    private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        bounds.x += deltaX;
        bounds.y += deltaY;
        bounds.width += deltaWidth;
        bounds.height += deltaHeight;
        if (min != null) {
            int correction;
            if (bounds.width < min.width) {
                correction = min.width - bounds.width;
                if (deltaX != 0) {
                    bounds.x -= correction;
                }
                bounds.width = min.width;
            }
            if (bounds.height < min.height) {
                correction = min.height - bounds.height;
                if (deltaY != 0) {
                    bounds.y -= correction;
                }
                bounds.height = min.height;
            }
        }
    }

    public void setDragArea(LuckRectangle dragArea) {
        this.dragArea = dragArea;
    }

    public void setTitleArea(LuckRectangle titleArea) {
        this.titleArea = titleArea;
    }
}

