/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.event;

import freeseawind.lf.border.LuckBorderField;
import freeseawind.lf.border.LuckShapeBorder;
import freeseawind.lf.event.LuckFocusHandle;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public abstract class LuckBorderFocusHandle
extends LuckFocusHandle {
    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isLuckLineBorder()) {
            this.handleFocusGained();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Component source = (Component)e.getSource();
        if (this.isLuckLineBorder() && !source.contains(e.getPoint())) {
            this.handleFocusLost();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.isLuckLineBorder()) {
            this.handleFocusLost();
        }
    }

    public abstract JComponent getComponent();

    public abstract LuckBorderField getBorderField();

    protected void handleFocusLost() {
        if (this.getBorderField().isFocusGaind() && !this.getComponent().isFocusOwner()) {
            this.getBorderField().setFocusGained(false);
            this.getComponent().repaint();
        }
    }

    protected void handleFocusGained() {
        if (!this.getBorderField().isFocusGaind() && this.getComponent().isEnabled()) {
            this.getBorderField().setFocusGained(true);
            this.getComponent().repaint();
        }
    }

    private boolean isLuckLineBorder() {
        return this.getComponent().getBorder() instanceof LuckShapeBorder;
    }
}

