/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.controller;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.SwingConstants;

public class LuckArrowButton
extends JButton
implements SwingConstants {
    protected int direction;
    protected Color normal;
    protected Color highlight;
    private static final long serialVersionUID = -5455122549884120624L;

    public LuckArrowButton(int direction) {
        this(direction, new Color(122, 138, 153), new Color(60, 175, 210));
    }

    public LuckArrowButton(int direction, Color normal, Color highlight) {
        this.setRequestFocusEnabled(false);
        this.setDirection(direction);
        this.normal = normal;
        this.highlight = highlight;
        this.setContentAreaFilled(false);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getModel().isPressed()) {
            g.translate(1, 1);
        }
        int w = this.getSize().width;
        int h = this.getSize().height;
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 3);
        this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction);
        if (this.getModel().isPressed()) {
            g.translate(-1, -1);
        }
    }

    public void paintTriangle(Graphics g, int x, int y, int size, int direction) {
        int mid = 0;
        int i = 0;
        int j = 0;
        size = Math.min(4, size);
        mid = size / 2;
        g.translate(x, y);
        g.setColor(this.getArrowColor(this.model));
        switch (direction) {
            case 1: {
                for (i = 0; i < size; ++i) {
                    g.drawLine(mid - i, i, mid + i, i);
                }
                break;
            }
            case 5: {
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(mid - i, j, mid + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                for (i = 0; i < size; ++i) {
                    g.drawLine(i, mid - i, i, mid + i);
                }
                break;
            }
            case 3: {
                j = 0;
                for (i = size - 1; i >= 0; --i) {
                    g.drawLine(j, mid - i, j, mid + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
    }

    protected Color getArrowColor(ButtonModel model) {
        if (model.isPressed()) {
            return this.highlight;
        }
        return this.normal;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16, 16);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }
}

