/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.canvas;

import freeseawind.lf.canvas.LuckCanvas;
import freeseawind.lf.utils.LuckPlatformUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class LuckOpaquePainter {
    public <T extends JComponent, E extends LuckCanvas> void paintOpaque(Graphics g, T component, E canvas) {
        if (!component.isOpaque()) {
            canvas.drawComponent(g, component);
            return;
        }
        this.paintOpaque(g, component, canvas, null);
    }

    public <T extends JComponent, E extends LuckCanvas> void paintOpaqueShap(Graphics g, T component, E canvas, Shape shape) {
        if (!component.isOpaque()) {
            canvas.drawComponent(g, component);
            return;
        }
        this.paintOpaque(g, component, canvas, shape);
    }

    public <T extends JComponent, E extends LuckCanvas> void paintOpaque(Graphics g, T component, E canvas, Shape shape) {
        Insets insets = component.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = component.getWidth() - insets.left - insets.right;
        int height = component.getHeight() - insets.top - insets.bottom;
        int imageType = 1;
        if (!LuckPlatformUtils.isWindows()) {
            imageType = 3;
        }
        BufferedImage contentImage = new BufferedImage(width, height, imageType);
        Graphics2D contentG2d = contentImage.createGraphics();
        canvas.drawComponent(contentG2d, component);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (shape != null) {
            g2d.fill(shape);
            g2d.setComposite(AlphaComposite.SrcAtop);
        }
        g.drawImage(contentImage, x, y, width, height, null);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        contentG2d.dispose();
    }
}

