/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.border;

import freeseawind.lf.border.LuckBorderField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RectangularShape;
import javax.swing.border.AbstractBorder;

public abstract class LuckShapeBorder
extends AbstractBorder {
    private static final long serialVersionUID = -6529775355312979219L;
    private Insets insets;
    private Color normalColor;
    private Color focusColor;
    private Color outShadowColor;
    private Color innerShadowColor;

    public LuckShapeBorder(Insets i) {
        this.insets = i;
        this.normalColor = new Color(190, 190, 190);
        this.focusColor = new Color(3, 158, 211);
        this.outShadowColor = new Color(179, 218, 231);
        this.innerShadowColor = new Color(221, 242, 249);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RectangularShape shape = this.getBorderShape(c);
        if (shape != null) {
            shape.setFrame(x, y, width - 1, height - 1);
            if (!this.isFocusGained(c)) {
                g2d.setColor(this.normalColor);
                g2d.draw(shape);
            } else {
                g2d.setColor(this.outShadowColor);
                g2d.draw(shape);
                g2d.setColor(this.innerShadowColor);
                g2d.drawRect(x + 2, y + 2, width - 5, height - 5);
                g2d.setColor(this.focusColor);
                shape.setFrame(x + 1, y + 1, width - 3, height - 3);
                g2d.draw(shape);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.insets;
    }

    public boolean isFocusGained(Component c) {
        LuckBorderField field = this.getBorderField(c);
        return this.isFoucusGaind(field);
    }

    public RectangularShape getBorderShape(Component c) {
        LuckBorderField field = this.getBorderField(c);
        return this.getBorderShape(field, c);
    }

    public abstract LuckBorderField getBorderField(Component var1);

    private RectangularShape getBorderShape(LuckBorderField field, Component c) {
        if (field != null) {
            return field.getBorderShape();
        }
        return c.getBounds();
    }

    private boolean isFoucusGaind(LuckBorderField field) {
        if (field != null) {
            return field.isFocusGaind();
        }
        return false;
    }
}

