/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class LuckLineBorder
extends AbstractBorder {
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 4;
    public static final int EAST = 8;
    private int rule = 15;
    private Insets insets;
    private Color color;
    private static final long serialVersionUID = 8187996726188029495L;

    public LuckLineBorder(Insets insets) {
        this(insets, 15);
    }

    public LuckLineBorder(Insets insets, int rule) {
        this(insets, rule, new Color(200, 200, 200));
    }

    public LuckLineBorder(Insets insets, int rule, Color color) {
        this.color = color;
        this.insets = insets;
        if (rule > 0 && rule <= 15) {
            this.rule = rule;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.color);
        if ((this.rule & 1) != 0) {
            g.drawLine(0, 0, width, 0);
        }
        if ((this.rule & 4) != 0) {
            g.drawLine(0, 0, 0, height);
        }
        if ((this.rule & 2) != 0) {
            g.drawLine(0, height - 1, width, height - 1);
        }
        if ((this.rule & 8) != 0) {
            g.drawLine(width - 1, 0, width - 1, height);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }
}

