/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.togglebutton;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;

public class LuckRadioIcon
implements Icon,
Serializable {
    private static final long serialVersionUID = -6004636765123462175L;

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton cb = (AbstractButton)c;
        ButtonModel model = cb.getModel();
        boolean isPressed = model.isArmed() && model.isPressed();
        boolean isRollver = model.isRollover() && cb.isRolloverEnabled();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawOval(g2d, x, y, isRollver || isPressed);
        if (model.isSelected()) {
            this.fillOval(g2d, x, y);
        } else if (isRollver && isPressed) {
            this.drawOvalShadow(g2d, x, y);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void drawOval(Graphics2D g2d, int x, int y, boolean isFocus) {
        if (!isFocus) {
            g2d.setColor(UIManager.getColor("RadioButton.normalColor"));
        } else {
            g2d.setColor(UIManager.getColor("RadioButton.focusColor"));
        }
        g2d.drawOval(x + this.getLeftInset(), y + this.getTopInset(), this.getIconWidth() - 3, this.getIconHeight() - 3);
    }

    protected void drawOvalShadow(Graphics2D g2d, int x, int y) {
        g2d.setColor(UIManager.getColor("RadioButton.shadowColor"));
        g2d.drawOval(x + 1 + this.getLeftInset(), y + 1 + this.getTopInset(), this.getIconWidth() - 5, this.getIconHeight() - 5);
    }

    protected void fillOval(Graphics2D g2d, int x, int y) {
        g2d.setColor(UIManager.getColor("RadioButton.checkColor"));
        g2d.fillOval(x + 4 + this.getLeftInset(), y + 4 + this.getTopInset(), this.getIconWidth() - 10, this.getIconHeight() - 10);
    }

    @Override
    public int getIconWidth() {
        return 15;
    }

    @Override
    public int getIconHeight() {
        return 15;
    }

    public int getTopInset() {
        return 0;
    }

    public int getLeftInset() {
        return 0;
    }
}

