/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.text;

import freeseawind.lf.border.LuckBorderField;
import freeseawind.lf.border.LuckShapeBorder;
import freeseawind.lf.event.LuckBorderFocusHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class LuckPasswordFieldUI
extends BasicPasswordFieldUI
implements LuckBorderField {
    protected LuckBorderFocusHandle handle;
    private RectangularShape borderShape;
    private boolean isFocusGained;

    public static ComponentUI createUI(JComponent c) {
        return new LuckPasswordFieldUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c.getBorder() instanceof LuckShapeBorder) {
            this.installFocusListener(c);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallFocusListener(c);
    }

    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent editor = this.getComponent();
        ((Graphics2D)g).setColor(editor.getBackground());
        this.borderShape.setFrame(0.0, 0.0, editor.getWidth() - 1, editor.getHeight() - 1);
        ((Graphics2D)g).fill(this.borderShape);
    }

    protected void installFocusListener(JComponent c) {
        this.handle = this.createFocusHandle();
        this.borderShape = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f);
        c.addMouseListener(this.handle);
        c.addFocusListener(this.handle);
    }

    protected void uninstallFocusListener(JComponent c) {
        if (this.handle != null) {
            c.removeMouseListener(this.handle);
            c.removeFocusListener(this.handle);
            this.handle = null;
        }
        this.borderShape = null;
    }

    protected LuckBorderFocusHandle createFocusHandle() {
        return new LuckFocusHandler();
    }

    @Override
    public void setFocusGained(boolean isFoucusGaind) {
        this.isFocusGained = isFoucusGaind;
    }

    @Override
    public boolean isFocusGaind() {
        return this.isFocusGained;
    }

    @Override
    public RectangularShape getBorderShape() {
        return this.borderShape;
    }

    public void setBorderShape(RectangularShape shape) {
        this.borderShape = shape;
    }

    public class LuckFocusHandler
    extends LuckBorderFocusHandle {
        @Override
        public JComponent getComponent() {
            return LuckPasswordFieldUI.this.getComponent();
        }

        @Override
        public LuckBorderField getBorderField() {
            return LuckPasswordFieldUI.this;
        }
    }
}

