/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.table;

import freeseawind.lf.border.LuckLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;

public class LuckTableCellHeaderRenderer
extends JLabel
implements TableCellRenderer,
Serializable,
UIResource {
    private static final long serialVersionUID = 4540501865134659334L;
    protected Border noramlBorder;
    protected Border endColumnBorder;
    protected Color outerGradientStart;
    protected Color outerGradientEnd;
    protected Color innerGradientStart;
    protected Color innerGradientEnd;

    public LuckTableCellHeaderRenderer() {
        this.setOpaque(false);
        this.setHorizontalAlignment(0);
        this.setHorizontalTextPosition(2);
        this.setIconTextGap(6);
        this.setName("Table.cellRenderer");
        this.outerGradientStart = new Color(252, 252, 252);
        this.outerGradientEnd = new Color(226, 226, 226);
        this.innerGradientStart = new Color(238, 238, 238);
        this.innerGradientEnd = new Color(217, 217, 217);
        this.noramlBorder = new LuckLineBorder(new Insets(0, 0, 1, 1), 10);
        this.endColumnBorder = new LuckLineBorder(new Insets(0, 0, 1, 0), 2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        SortOrder sortOrder;
        if (table == null) {
            return this;
        }
        if (column == table.getColumnCount() - 1) {
            this.setBorder(this.endColumnBorder);
        } else {
            this.setBorder(this.noramlBorder);
        }
        boolean isPaintingForPrint = false;
        if (table.getTableHeader() != null) {
            isPaintingForPrint = table.getTableHeader().isPaintingForPrint();
        }
        Icon sortIcon = null;
        if (!isPaintingForPrint && table.getRowSorter() != null && (sortOrder = LuckTableCellHeaderRenderer.getColumnSortOrder(table, column)) != null) {
            switch (sortOrder) {
                case ASCENDING: {
                    sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                    break;
                }
                case DESCENDING: {
                    sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                    break;
                }
            }
        }
        this.setIcon(sortIcon);
        this.setFont(table.getFont());
        this.setValue(value);
        return this;
    }

    public static SortOrder getColumnSortOrder(JTable table, int column) {
        SortOrder rv = null;
        if (table == null || table.getRowSorter() == null) {
            return rv;
        }
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
            rv = sortKeys.get(0).getSortOrder();
        }
        return rv;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle dimension = this.getBounds();
        Insets i = this.getInsets();
        int w = dimension.width;
        int h = dimension.height;
        GradientPaint outerGradient = new GradientPaint(0.0f, 0.0f, this.outerGradientStart, 0.0f, h - 2, this.outerGradientEnd);
        ((Graphics2D)g).setPaint(outerGradient);
        g.fillRect(0, 0, w - i.left - i.right, h - 1);
        GradientPaint innerGradient = new GradientPaint(1.0f, 1.0f, this.innerGradientStart, 1.0f, h - 2, this.innerGradientEnd);
        ((Graphics2D)g).setPaint(innerGradient);
        g.fillRect(1, 1, w - i.left - i.right - 2, h - 3);
        super.paintComponent(g);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("text")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
        if (propertyName.equals("labelFor")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
        if (propertyName.equals("displayedMnemonic")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
        if ((propertyName.equals("font") || propertyName.equals("foreground")) && oldValue != newValue && "html" != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }
}

