/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.tabbedpane;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class LuckTabbedPaneUI
extends BasicTabbedPaneUI {
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 4;
    public static final int EAST = 8;
    protected Color selectedColor;
    protected Color selectedShadow;

    public static ComponentUI createUI(JComponent c) {
        return new LuckTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.selectedShadow = UIManager.getColor("TabbedPane.selectedShadow");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectedColor = null;
        this.selectedShadow = null;
    }

    @Override
    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(!isSelected || this.selectedColor == null ? this.tabPane.getBackgroundAt(tabIndex) : this.selectedColor);
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x, y + 1, w, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w, h - 3);
                break;
            }
            case 1: 
            case 3: {
                g.fillRect(x + 2, y + 1, w - 2, h - 1);
                break;
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (!isSelected) {
            g.setColor(this.shadow);
        } else {
            g.setColor(this.selectedShadow);
        }
        switch (tabPlacement) {
            case 2: {
                this.paintBorder(g, x, y + 1, w - 1, h - 2, 7);
                break;
            }
            case 4: {
                this.paintBorder(g, x, y + 1, w - 1, h - 2, 11);
                break;
            }
            case 1: {
                this.paintBorder(g, x + 1, y, w - 2, h, 13);
                break;
            }
            case 3: {
                this.paintBorder(g, x + 1, y + 1, w - 2, h, 14);
                break;
            }
        }
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 1) {
            g.setColor(UIManager.getColor("TabbedPane.shadow"));
            g.drawLine(x, y, x + w, y);
        }
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 2) {
            g.setColor(UIManager.getColor("TabbedPane.shadow"));
            g.drawLine(x, y, x, y + h);
        }
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 3) {
            g.setColor(UIManager.getColor("TabbedPane.shadow"));
            g.drawLine(x, y + h, x + w, y + h);
        }
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        if (tabPlacement == 4) {
            g.setColor(UIManager.getColor("TabbedPane.shadow"));
            g.drawLine(x + w, y, x + w, y + h);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    private void paintBorder(Graphics g, int x, int y, int width, int height, int rule) {
        if ((rule & 1) != 0) {
            g.drawLine(x, y, x + width, y);
        }
        if ((rule & 4) != 0) {
            g.drawLine(x, y, x, y + height - 1);
        }
        if ((rule & 2) != 0) {
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
        if ((rule & 8) != 0) {
            g.drawLine(x + width, y, x + width, y + height - 1);
        }
    }
}

