/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.slider;

import freeseawind.lf.utils.LuckUtils;
import freeseawind.ninepatch.swing.SwingNinePatch;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class LuckSliderUI
extends MetalSliderUI {
    private SwingNinePatch horizontalNp;
    private SwingNinePatch horizontalHighlightNp;
    private SwingNinePatch verticalNp;
    private SwingNinePatch verticalHighlightNp;
    private BufferedImage horizontaltThumbImg;
    private BufferedImage verticalThumbImg;
    private int size;

    public LuckSliderUI(JSlider b) {
    }

    public static ComponentUI createUI(JComponent b) {
        return new LuckSliderUI((JSlider)b);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.size = UIManager.getInt("Slider.trackSize");
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.horizontalNp = null;
        this.horizontalHighlightNp = null;
        this.verticalNp = null;
        this.verticalHighlightNp = null;
        this.horizontaltThumbImg = null;
        this.verticalThumbImg = null;
    }

    @Override
    public void paintTrack(Graphics g) {
        this.initRes(this.slider.getOrientation());
        Rectangle trackBounds = this.trackRect;
        Graphics2D g2d = (Graphics2D)g;
        if (this.slider.getOrientation() == 0) {
            int cy = trackBounds.height / 2 - 2;
            g.translate(trackBounds.x, trackBounds.y + cy);
            this.horizontalNp.drawNinePatch((Object)g2d, 0, 0, trackBounds.width, this.size);
            this.horizontalHighlightNp.drawNinePatch((Object)g2d, 0, 0, this.thumbRect.x - 2, this.size);
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            int cx = trackBounds.width / 2 - 2;
            g.translate(trackBounds.x + cx, trackBounds.y);
            this.verticalNp.drawNinePatch((Object)g2d, 0, 0, this.size, trackBounds.height);
            this.verticalHighlightNp.drawNinePatch((Object)g2d, 0, this.thumbRect.y, this.size, trackBounds.height - this.thumbRect.y);
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        this.initRes(this.slider.getOrientation());
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.getOrientation() == 0) {
            g.drawImage(this.horizontaltThumbImg, 0, 0, null);
        } else {
            g.drawImage(this.verticalThumbImg, 0, 0, null);
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    protected void initRes(int orientation) {
        if (orientation == 0) {
            this.initHorizontalRes();
        } else {
            this.initVerticalRes();
        }
    }

    protected void initHorizontalRes() {
        if (this.horizontalNp == null) {
            this.horizontalNp = LuckUtils.createNinePatch("Slider.trackHorizontal");
        }
        if (this.horizontalHighlightNp == null) {
            this.horizontalHighlightNp = LuckUtils.createNinePatch("Slider.trackHorizontalHighlight");
        }
        if (this.horizontaltThumbImg == null) {
            this.horizontaltThumbImg = LuckUtils.getUiImage("Slider.thumbHorizontalImg");
        }
    }

    protected void initVerticalRes() {
        if (this.verticalNp == null) {
            this.verticalNp = LuckUtils.createNinePatch("Slider.trackVertical");
        }
        if (this.verticalHighlightNp == null) {
            this.verticalHighlightNp = LuckUtils.createNinePatch("Slider.trackVerticalHighlight");
        }
        if (this.verticalThumbImg == null) {
            this.verticalThumbImg = LuckUtils.getUiImage("Slider.thumbVerticalImg");
        }
    }
}

