/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.scroll;

import freeseawind.lf.utils.LuckUtils;
import freeseawind.ninepatch.swing.SwingNinePatch;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class LuckScrollBarUI
extends BasicScrollBarUI {
    private SwingNinePatch np;
    private int width;

    public static ComponentUI createUI(JComponent c) {
        return new LuckScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.np = LuckUtils.createNinePatch("Scrollbar.thumbIcon");
        this.width = UIManager.getInt("ScrollBar.width");
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.np = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.scrollbar, "opaque", Boolean.FALSE);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        JButton btn = new JButton();
        btn.setVisible(false);
        btn.setPreferredSize(new Dimension(0, 0));
        return btn;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        JButton btn = new JButton();
        btn.setVisible(false);
        btn.setPreferredSize(new Dimension(0, 0));
        return btn;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        int w = thumbBounds.width;
        int h = thumbBounds.height;
        g.translate(thumbBounds.x, thumbBounds.y);
        if (this.scrollbar.getOrientation() == 1) {
            --w;
        } else if (this.scrollbar.getOrientation() == 0) {
            --h;
        }
        Graphics2D g2d = (Graphics2D)g;
        AlphaComposite composite = (AlphaComposite)g2d.getComposite();
        if (!this.isThumbRollover()) {
            AlphaComposite transulent = AlphaComposite.getInstance(10, 0.7f);
            g2d.setComposite(transulent);
        }
        if (this.np != null) {
            this.np.drawNinePatch((Object)g2d, 0, 0, w, h);
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
        g2d.setComposite(composite);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.scrollbar.getOrientation() == 1 ? new Dimension(this.width, 48) : new Dimension(48, this.width);
    }
}

