/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.rootpane;

import freeseawind.lf.basic.rootpane.LuckTitlePanel;
import freeseawind.lf.layout.AbstractLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class LuckTitlePanelLayout
extends AbstractLayout {
    @Override
    public void layoutContainer(Container parent) {
        JButton minBtn;
        JButton maximizeBtn;
        LuckTitlePanel titlePanel = (LuckTitlePanel)parent;
        Rectangle bound = parent.getBounds();
        Insets insets = parent.getInsets();
        int w = bound.width - insets.right - insets.left;
        if (w <= 0) {
            return;
        }
        boolean isLeftToRight = titlePanel.isLeftToRight();
        JButton closebtn = titlePanel.getCloseBtn();
        int startX = isLeftToRight ? bound.width - insets.right : 0;
        int startY = insets.top;
        if (closebtn != null && closebtn.isVisible()) {
            int closeBtnW = closebtn.getIcon().getIconWidth();
            int closeBtnH = closebtn.getIcon().getIconHeight();
            startX = isLeftToRight ? startX - closeBtnW : startX;
            closebtn.setBounds(startX, startY, closeBtnW, closeBtnH);
            int n = startX = isLeftToRight ? startX : startX + closeBtnW;
        }
        if ((maximizeBtn = titlePanel.getMaximizeBtn()) != null && maximizeBtn.isVisible()) {
            int maximizeBtnW = maximizeBtn.getIcon().getIconWidth();
            int maximizeBtnH = maximizeBtn.getIcon().getIconHeight();
            startX = isLeftToRight ? startX - maximizeBtnW : startX;
            maximizeBtn.setBounds(startX, startY, maximizeBtnW, maximizeBtnH);
            int n = startX = isLeftToRight ? startX : startX + maximizeBtnW;
        }
        if ((minBtn = titlePanel.getMinBtn()) != null && minBtn.isVisible()) {
            int minBtnW = minBtn.getIcon().getIconWidth();
            int minBtnH = minBtn.getIcon().getIconHeight();
            startX = isLeftToRight ? startX - minBtnW : startX;
            minBtn.setBounds(startX, startY, minBtnW, minBtnH);
            startX = isLeftToRight ? startX : startX + minBtnW;
        }
        JLabel titleLabel = titlePanel.getLabel();
        String text = titleLabel.getText();
        FontMetrics ff = titleLabel.getFontMetrics(titleLabel.getFont());
        int labelW = 0;
        if (text != null) {
            labelW = ff.stringWidth(text) + titleLabel.getIconTextGap();
        }
        int labelH = ff.getHeight();
        Icon labelIcon = titleLabel.getIcon();
        if (labelIcon != null) {
            labelW += labelIcon.getIconWidth();
            labelH = Math.max(labelH, labelIcon.getIconHeight());
        }
        startX = isLeftToRight ? 0 : (w - labelW) / 2;
        Insets titleInsets = UIManager.getInsets("Application.icon.insets");
        titleLabel.setBounds(startX + titleInsets.left, 0 + titleInsets.top, labelW, labelH);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        LuckTitlePanel root = (LuckTitlePanel)parent;
        Insets i = parent.getInsets();
        return new Dimension(0 + i.left + i.right, root.getHeight() + i.top + i.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }
}

