/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.rootpane;

import freeseawind.lf.basic.rootpane.LuckTitlePanelLayout;
import freeseawind.lf.canvas.LuckCanvas;
import freeseawind.lf.event.LuckWindowAdapter;
import freeseawind.lf.event.WindowBtnMouseAdapter;
import freeseawind.lf.event.WindowPropertyListener;
import freeseawind.lf.utils.LuckWindowUtil;
import freeseawind.ninepatch.swing.SwingNinePatch;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LuckTitlePanel
extends JPanel {
    private static final long serialVersionUID = -8111081484864247330L;
    private static final int ICON_HEIGHT = 16;
    private static final int ICON_WIDTH = 16;
    protected JButton maximizeBtn;
    protected JButton minBtn;
    protected JButton closeBtn;
    protected JLabel label;
    protected WindowPropertyListener listener;
    protected WindowAdapter windowAdapter;
    protected Window window;
    private SwingNinePatch np;
    private LuckCanvas painter;
    private int initStyle;
    private boolean isResizeableOnInit;
    private int state;

    public LuckTitlePanel(boolean isResizeableOnInit, int initStyle) {
        this.setOpaque(false);
        this.setLayout(this.createLayout());
        this.isResizeableOnInit = isResizeableOnInit;
        this.initStyle = initStyle;
        this.state = 0;
        Object obj = UIManager.get("TitlePanel.bg.img");
        if (obj != null) {
            this.np = new SwingNinePatch((BufferedImage)obj);
        }
        this.installTitle();
        this.installBtn();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.np != null) {
            this.np.drawNinePatch((Object)((Graphics2D)g), 0, 0, this.getWidth(), this.getHeight());
        }
        if (this.painter != null) {
            this.painter.drawComponent(g, this);
        }
    }

    public boolean isLeftToRight() {
        boolean leftToRight = this.getWindow() == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : this.getWindow().getComponentOrientation().isLeftToRight();
        return leftToRight;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.window = this.getWindow();
        if (this.window != null) {
            String title = LuckWindowUtil.getWindowTitle(this.window);
            this.setTitle(title);
            Image image = LuckWindowUtil.getWindowImage(this.window);
            if (image != null) {
                this.setIcon(new ImageIcon(image));
            }
            if (this.listener == null) {
                this.listener = new WindowPropertyListener(this);
                this.window.addPropertyChangeListener(this.listener);
            }
            if (this.windowAdapter == null && this.window instanceof JFrame) {
                this.windowAdapter = new LuckWindowAdapter();
                this.window.addWindowStateListener(this.windowAdapter);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.window != null) {
            if (this.listener != null) {
                this.window.removePropertyChangeListener(this.listener);
            }
            if (this.windowAdapter != null && this.window instanceof JFrame) {
                this.window.removeWindowStateListener(this.windowAdapter);
            }
            this.window = null;
            this.listener = null;
        }
    }

    public void setResizeable(boolean isResizeable) {
        if (isResizeable) {
            this.maximizeBtn.setVisible(true);
        } else {
            this.maximizeBtn.setVisible(false);
        }
    }

    public LayoutManager createLayout() {
        return new LuckTitlePanelLayout();
    }

    protected void installBtn() {
        this.closeBtn = new JButton();
        this.closeBtn.addMouseListener(new CloseMouseAdapter(this.closeBtn, "Frame.closeNormal", "Frame.closeRover", "Frame.closePressed"));
        this.setBtnAtrr(this.closeBtn);
        this.add(this.closeBtn);
        if (this.initStyle == 1) {
            this.minBtn = new JButton();
            this.minBtn.addMouseListener(new MinMouseAdapter(this.minBtn, "Frame.minNormal", "Frame.minRover", "Frame.minPressed"));
            this.setBtnAtrr(this.minBtn);
            this.add(this.minBtn);
            this.maximizeBtn = new JButton();
            this.maximizeBtn.addMouseListener(new MaximizeMouseAdapter(this.maximizeBtn, "Frame.maxNormal", "Frame.maxRover", "Frame.maxPressed"));
            this.setBtnAtrr(this.maximizeBtn);
            this.add(this.maximizeBtn);
            if (!this.isResizeableOnInit) {
                this.maximizeBtn.setVisible(false);
            }
        }
    }

    protected void installTitle() {
        this.label = new JLabel();
        this.label.setIcon(UIManager.getIcon("Application.icon"));
        this.label.setText(UIManager.getString("Application.title"));
        this.label.setHorizontalAlignment(0);
        this.label.setIconTextGap(UIManager.getInt("Application.title.textgap"));
        this.label.setForeground(UIManager.getColor("Title.font.color"));
        this.add(this.label);
    }

    protected void setBtnAtrr(JButton btn) {
        btn.setOpaque(false);
        btn.setBorder(null);
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBackground(null);
        btn.setContentAreaFilled(false);
    }

    private Window getWindow() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private void updateMaximizeBtn() {
        if ((this.state & 6) != 0) {
            this.maximizeBtn.setIcon(UIManager.getIcon("Frame.maxmizeNormal"));
            this.maximizeBtn.setRolloverIcon(UIManager.getIcon("Frame.maxmizeRover"));
            this.maximizeBtn.setPressedIcon(UIManager.getIcon("Frame.maxmizePressed"));
        } else {
            this.maximizeBtn.setIcon(UIManager.getIcon("Frame.maxNormal"));
            this.maximizeBtn.setRolloverIcon(UIManager.getIcon("Frame.maxRover"));
            this.maximizeBtn.setPressedIcon(UIManager.getIcon("Frame.maxPressed"));
        }
    }

    @Override
    public int getHeight() {
        return UIManager.getInt("TitlePanel.height");
    }

    public JButton getMaximizeBtn() {
        return this.maximizeBtn;
    }

    public JButton getMinBtn() {
        return this.minBtn;
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    public void setIcon(ImageIcon systemIcon) {
        if (systemIcon == null) {
            this.label.setIcon(systemIcon);
            return;
        }
        Image image = systemIcon.getImage();
        if (image.getHeight(null) < 16 || image.getWidth(null) < 16) {
            return;
        }
        if (image.getHeight(null) > 16 || image.getWidth(null) > 16) {
            image = image.getScaledInstance(16, 16, 4);
            systemIcon = new ImageIcon(image);
        }
        this.label.setIcon(systemIcon);
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public void setTitleForeground(Color color) {
        this.label.setForeground(color);
    }

    public void setCallback(LuckCanvas painter) {
        this.painter = painter;
    }

    public void setState(int state) {
        this.state = state;
        this.updateMaximizeBtn();
    }

    public void setBackgroundNP(SwingNinePatch np) {
        this.np = np;
    }

    public JLabel getLabel() {
        return this.label;
    }

    private class MaximizeMouseAdapter
    extends WindowBtnMouseAdapter {
        public MaximizeMouseAdapter(JButton btn, String normalIconKey, String hoverIconKey, String pressIconKey) {
            super(btn, normalIconKey, hoverIconKey, pressIconKey);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Window window = LuckTitlePanel.this.getWindow();
            if (window instanceof JFrame) {
                JFrame frame = (JFrame)window;
                LuckTitlePanel.this.maximizeBtn.setEnabled(false);
                if ((LuckTitlePanel.this.state & 1) != 0) {
                    frame.setExtendedState(LuckTitlePanel.this.state & 0xFFFFFFFE);
                } else if ((LuckTitlePanel.this.state & 6) != 0) {
                    frame.setExtendedState(LuckTitlePanel.this.state & 0xFFFFFFF9);
                } else {
                    frame.setExtendedState(LuckTitlePanel.this.state | 6);
                }
                LuckTitlePanel.this.maximizeBtn.setEnabled(true);
            }
        }
    }

    private class MinMouseAdapter
    extends WindowBtnMouseAdapter {
        public MinMouseAdapter(JButton btn, String normalIconKey, String hoverIconKey, String pressIconKey) {
            super(btn, normalIconKey, hoverIconKey, pressIconKey);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Window window = LuckTitlePanel.this.getWindow();
            if (window instanceof JFrame) {
                LuckTitlePanel.this.minBtn.setEnabled(false);
                ((JFrame)window).setExtendedState(LuckTitlePanel.this.state | 1);
                LuckTitlePanel.this.minBtn.setEnabled(true);
            }
        }
    }

    private class CloseMouseAdapter
    extends WindowBtnMouseAdapter {
        public CloseMouseAdapter(JButton btn, String normalIconKey, String hoverIconKey, String pressIconKey) {
            super(btn, normalIconKey, hoverIconKey, pressIconKey);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Window window = LuckTitlePanel.this.getWindow();
            if (window != null) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        }
    }
}

