/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.rootpane;

import freeseawind.lf.basic.rootpane.LuckBackgroundPanel;
import freeseawind.lf.basic.rootpane.LuckRootPaneLayout;
import freeseawind.lf.basic.rootpane.LuckTitlePanel;
import freeseawind.lf.event.WindowMouseHandler;
import freeseawind.lf.geom.LuckRectangle;
import freeseawind.lf.utils.LuckPlatformUtils;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class LuckRootPaneUI
extends BasicRootPaneUI {
    public static final String WINDOWDECORATIONSTYLE_EVENT = "windowDecorationStyle";
    public static final String ANCESTOR_EVENT = "ancestor";
    protected LuckTitlePanel titlePane;
    private WindowMouseHandler mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};

    public static ComponentUI createUI(JComponent c) {
        return new LuckRootPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        JRootPane root = (JRootPane)c;
        int style = root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(root);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations((JRootPane)c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        JRootPane root = (JRootPane)e.getSource();
        Container parent = root.getParent();
        if (!(parent instanceof Window)) {
            return;
        }
        if (WINDOWDECORATIONSTYLE_EVENT.equals(propertyName)) {
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        } else if (ANCESTOR_EVENT.equals(propertyName)) {
            this.uninstallWindowListener(root);
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(root);
            }
        }
    }

    public LayoutManager createLayout() {
        return new LuckRootPaneLayout();
    }

    public void setDragArea(LuckRectangle dragArea) {
        this.mouseInputListener.setDragArea(dragArea);
    }

    protected LuckTitlePanel createTitlePanel(int style, boolean isResize) {
        this.titlePane = new LuckTitlePanel(isResize, style);
        return this.titlePane;
    }

    protected LuckBackgroundPanel createContentPane(LuckTitlePanel titlePanel, Container oldContent) {
        return new LuckBackgroundPanel(oldContent, titlePanel);
    }

    protected MouseInputListener installWindowListeners(JRootPane root) {
        Window window = SwingUtilities.getWindowAncestor(root);
        if (window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = new WindowMouseHandler(root);
            }
            window.addMouseListener(this.mouseInputListener);
            window.addMouseMotionListener(this.mouseInputListener);
        }
        return this.mouseInputListener;
    }

    protected void uninstallWindowListener(JRootPane root) {
        Window window = SwingUtilities.getWindowAncestor(root);
        if (window != null && this.mouseInputListener != null) {
            window.removeMouseListener(this.mouseInputListener);
            window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    protected void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        this.installWindowListeners(root);
        this.installLayout(root);
        this.installOther(root);
    }

    protected void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListener(root);
        this.uninstallLayout(root);
        this.uninstallOther(root);
    }

    protected void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        root.setBorder(null);
        if (LuckPlatformUtils.isWindows()) {
            root.setBorder(UIManager.getBorder(borderKeys[style]));
        } else {
            root.setBorder(LineBorder.createBlackLineBorder());
        }
    }

    protected void installLayout(JRootPane root) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayout();
        }
        this.savedOldLayout = root.getLayout();
        root.setLayout(this.layoutManager);
    }

    protected void installOther(JRootPane root) {
        Window window = (Window)root.getParent();
        window.setBackground(UIManager.getColor("translucent.color"));
    }

    protected void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
        root.setBorder(null);
    }

    protected void uninstallLayout(JRootPane root) {
        if (this.savedOldLayout != null) {
            root.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
        this.layoutManager = null;
    }

    protected void uninstallOther(JRootPane root) {
        Window window;
        int style;
        Container content = root.getContentPane();
        if (content != null && content instanceof LuckBackgroundPanel) {
            LuckBackgroundPanel bgPanel = (LuckBackgroundPanel)content;
            root.setContentPane(bgPanel.getContentPane());
            root.setJMenuBar(bgPanel.getJMenuBar());
            bgPanel.uninstallMenubar(true);
        }
        if ((style = root.getWindowDecorationStyle()) == 0) {
            root.repaint();
            root.revalidate();
        }
        if ((window = SwingUtilities.getWindowAncestor(root)) != null) {
            window.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public LuckTitlePanel getTitlePane() {
        return this.titlePane;
    }
}

