/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.rootpane;

import freeseawind.lf.basic.rootpane.LuckBackgroundPanel;
import freeseawind.lf.basic.rootpane.LuckRootPaneUI;
import freeseawind.lf.basic.rootpane.LuckTitlePanel;
import freeseawind.lf.layout.AbstractLayout;
import freeseawind.lf.utils.LuckWindowUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LuckRootPaneLayout
extends AbstractLayout {
    @Override
    public void layoutContainer(Container parent) {
        JRootPane root = (JRootPane)parent;
        Rectangle bound = root.getBounds();
        Insets inset = root.getInsets();
        int w = bound.width - inset.right - inset.left;
        int h = bound.height - inset.top - inset.bottom;
        if (root.getLayeredPane() != null) {
            root.getLayeredPane().setBounds(inset.left, inset.top, w, h);
        }
        if (root.getGlassPane() != null) {
            root.getGlassPane().setBounds(inset.left, inset.top, w, h);
        }
        Container content = root.getContentPane();
        LuckRootPaneUI rootPaneUI = (LuckRootPaneUI)root.getUI();
        if (!(content instanceof LuckBackgroundPanel)) {
            Window window = SwingUtilities.getWindowAncestor(root);
            boolean isResizeableOnInit = LuckWindowUtil.isResizable(window);
            int initStyle = root.getWindowDecorationStyle();
            if (initStyle != 0) {
                LuckTitlePanel titlePanel = rootPaneUI.createTitlePanel(initStyle, isResizeableOnInit);
                LuckBackgroundPanel background = rootPaneUI.createContentPane(titlePanel, content);
                root.setContentPane(background);
            }
        }
        root.getContentPane().setBounds(0, 0, w, h);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        JRootPane root = (JRootPane)parent;
        int h = 0;
        Dimension cpd = null;
        if (root.getContentPane() != null) {
            cpd = root.getContentPane().getPreferredSize();
            if (!(root.getContentPane() instanceof LuckBackgroundPanel) && root.getWindowDecorationStyle() != 0) {
                h += UIManager.getInt("TitlePanel.height");
            }
        } else {
            cpd = root.getSize();
        }
        return this.getDimension(insets, cpd.width, h += cpd.height);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        JRootPane root = (JRootPane)parent;
        Dimension cpd = null;
        cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
        return this.getDimension(insets, cpd.width, cpd.height);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        JRootPane root = (JRootPane)parent;
        Dimension cpd = null;
        cpd = root.getContentPane() != null ? root.getContentPane().getMaximumSize() : root.getSize();
        return this.getDimension(insets, cpd.width, cpd.height);
    }
}

