/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.radiomenuitem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.UIManager;

public class LuckRadioIcon
implements Icon,
Serializable {
    private static final long serialVersionUID = -6004636765123462175L;

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        AbstractButton cb = (AbstractButton)c;
        ButtonModel model = cb.getModel();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawOval(g2d, x, y += 2, model.isArmed());
        if (model.isSelected()) {
            this.fillOval(g2d, x, y, model.isArmed());
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    protected void drawOval(Graphics2D g2d, int x, int y, boolean isFocus) {
        if (isFocus) {
            g2d.setColor(Color.WHITE);
        } else {
            g2d.setColor(UIManager.getColor("RadioButton.focusColor"));
        }
        g2d.drawOval(x, y, this.getIconWidth() - 3, this.getIconHeight() - 3);
    }

    protected void fillOval(Graphics2D g2d, int x, int y, boolean isFocus) {
        if (isFocus) {
            g2d.setColor(Color.WHITE);
        } else {
            g2d.setColor(UIManager.getColor("RadioButton.checkColor"));
        }
        g2d.fillOval(x + 4, y + 4, this.getIconWidth() - 10, this.getIconHeight() - 10);
    }

    @Override
    public int getIconWidth() {
        return 13;
    }

    @Override
    public int getIconHeight() {
        return 13;
    }
}

