/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.progress;

import freeseawind.lf.utils.LuckUtils;
import freeseawind.ninepatch.common.RepeatType;
import freeseawind.ninepatch.swing.SwingNinePatch;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class LuckProgressBarUI
extends BasicProgressBarUI {
    private Insets cellBarInsets;
    private SwingNinePatch horizontalNp;
    private SwingNinePatch horizontalCellNp;
    private SwingNinePatch verticalNp;
    private SwingNinePatch verticalCellNp;

    public static ComponentUI createUI(JComponent x) {
        return new LuckProgressBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.cellBarInsets = UIManager.getInsets("ProgressBar.thumbInsets");
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.horizontalNp = null;
        this.horizontalCellNp = null;
        this.verticalNp = null;
        this.verticalCellNp = null;
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        boolean isHorizontal = this.progressBar.getOrientation() == 0;
        Graphics2D g2 = (Graphics2D)g;
        this.paintProgressBarBg(g2, 0, 0, this.progressBar.getWidth(), this.progressBar.getHeight(), isHorizontal);
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            this.paintProgressBarCell(g2, this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, isHorizontal);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, 0, b);
            } else {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, 0, b);
            }
        }
    }

    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        boolean isHorizontal = this.progressBar.getOrientation() == 0;
        this.paintProgressBarBg(g2, b.left, b.top, barRectWidth, barRectHeight, isHorizontal);
        int cellWidth = barRectWidth;
        int cellHeight = barRectHeight;
        int startx = b.left;
        int starty = b.top;
        if (this.progressBar.getOrientation() == 0) {
            cellWidth = cellWidth - this.cellBarInsets.left - this.cellBarInsets.right;
            cellHeight = cellHeight - this.cellBarInsets.top - this.cellBarInsets.bottom;
            cellWidth = amountFull = amountFull < cellWidth ? amountFull : cellWidth;
            startx = b.left + this.cellBarInsets.left;
            starty = b.top + this.cellBarInsets.top;
        } else {
            cellWidth = cellWidth - this.cellBarInsets.top - this.cellBarInsets.bottom;
            cellHeight = amountFull = amountFull < (cellHeight = cellHeight - this.cellBarInsets.left - this.cellBarInsets.right) ? amountFull : cellHeight;
            startx = b.left + this.cellBarInsets.top;
            starty = b.top + barRectHeight - amountFull - this.cellBarInsets.top;
        }
        if (amountFull > 0) {
            this.paintProgressBarCell(g2, startx, starty, cellWidth, cellHeight, isHorizontal);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    protected void paintProgressBarBg(Graphics2D g2d, int x, int y, int w, int h, boolean isHorizontal) {
        this.configureProgressBarBg(isHorizontal);
        if (isHorizontal) {
            this.horizontalNp.drawNinePatch((Object)g2d, x, y, w, h);
        } else {
            this.verticalNp.drawNinePatch((Object)g2d, x, y, w, h);
        }
    }

    protected void paintProgressBarCell(Graphics2D g2d, int x, int y, int w, int h, boolean isHorizontal) {
        this.configureProgressBarCell(isHorizontal);
        if (isHorizontal) {
            this.horizontalCellNp.drawNinePatch((Object)g2d, x, y, w, h);
        } else {
            this.verticalCellNp.drawNinePatch((Object)g2d, x, y, w, h);
        }
    }

    protected void configureProgressBarBg(boolean isHorizontal) {
        if (isHorizontal && this.horizontalNp == null) {
            this.horizontalNp = LuckUtils.createNinePatch("ProgressBar.horizontalIcon");
        } else if (!isHorizontal && this.verticalNp == null) {
            this.verticalNp = LuckUtils.createNinePatch("ProgressBar.verticalIcon");
        }
    }

    protected void configureProgressBarCell(boolean isHorizontal) {
        if (isHorizontal && this.horizontalCellNp == null) {
            this.horizontalCellNp = LuckUtils.createNinePatch("ProgressBar.horizontalCellIcon", RepeatType.HORIZONTAL);
        } else if (!isHorizontal && this.verticalCellNp == null) {
            this.verticalCellNp = LuckUtils.createNinePatch("ProgressBar.verticalCellIcon", RepeatType.VERTICAL);
        }
    }
}

