/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.internalframe;

import freeseawind.lf.canvas.LuckCanvas;
import freeseawind.lf.canvas.LuckOpaquePainter;
import freeseawind.lf.layout.AbstractLayout;
import freeseawind.ninepatch.swing.SwingNinePatch;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class LuckInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LuckCanvas {
    private static final long serialVersionUID = 370015938063841015L;
    private LuckOpaquePainter painter = new LuckOpaquePainter();
    private SwingNinePatch np;

    public LuckInternalFrameTitlePane(JInternalFrame f) {
        super(f);
        Object obj = UIManager.get("InternalFrame.titlePanel.bgImg");
        if (obj != null) {
            this.np = new SwingNinePatch((BufferedImage)obj);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.painter.paintOpaque(g, this, this, null);
    }

    @Override
    public void drawComponent(Graphics g, JComponent c) {
        super.paint(g);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.maxIcon = null;
        this.minIcon = null;
        this.iconIcon = null;
        this.closeIcon = null;
        this.np = null;
    }

    @Override
    protected void paintTitleBackground(Graphics g) {
        if (this.np == null) {
            super.paintTitleBackground(g);
        } else {
            this.np.drawNinePatch((Object)((Graphics2D)g), 0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void installTitlePane() {
        super.installTitlePane();
        this.setLayout(new LuckTitlePaneLayout());
        this.menuBar.setEnabled(false);
    }

    @Override
    protected void setButtonIcons() {
        super.setButtonIcons();
        if (this.frame.isMaximum()) {
            this.setBtnAtrr(this.maxButton, "InternalFrame.maximizeIcon", "InternalFrame.maximizeIcon.rollver", "InternalFrame.maximizeIcon.pressed");
        } else {
            this.setBtnAtrr(this.maxButton, "InternalFrame.maxMinimizeIcon", "InternalFrame.maxMinimizeIcon.rollver", "InternalFrame.maxMinimizeIcon.pressed");
        }
        if (this.frame.isIcon()) {
            this.setBtnAtrr(this.iconButton, "InternalFrame.maximizeIcon", "InternalFrame.maximizeIcon.rollver", "InternalFrame.maximizeIcon.pressed");
            this.setBtnAtrr(this.maxButton, "InternalFrame.maxMinimizeIcon", "InternalFrame.maxMinimizeIcon.rollver", "InternalFrame.maxMinimizeIcon.pressed");
        } else {
            this.setBtnAtrr(this.iconButton, "InternalFrame.iconifyIcon", "InternalFrame.iconifyIcon.rollver", "InternalFrame.iconifyIcon.pressed");
        }
        this.setBtnAtrr(this.closeButton, "InternalFrame.closeIcon", "InternalFrame.closeIcon.rollver", "InternalFrame.closeIcon.pressed");
    }

    private void setBtnAtrr(JButton btn, String normalIcon, String rollverIcon, String pressedIcon) {
        btn.setBorder(null);
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBackground(null);
        btn.setContentAreaFilled(false);
        btn.setEnabled(false);
        btn.setIcon(UIManager.getIcon(normalIcon));
        btn.setRolloverIcon(UIManager.getIcon(rollverIcon));
        btn.setPressedIcon(UIManager.getIcon(pressedIcon));
        btn.setEnabled(true);
    }

    public class LuckTitlePaneLayout
    extends AbstractLayout {
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 22;
            int height = UIManager.getInt("InternalFrame.titlePanel.height");
            if (LuckInternalFrameTitlePane.this.frame.isClosable()) {
                width += LuckInternalFrameTitlePane.this.closeButton.getWidth();
            }
            if (LuckInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += LuckInternalFrameTitlePane.this.maxButton.getWidth();
            }
            if (LuckInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += LuckInternalFrameTitlePane.this.iconButton.getWidth();
            }
            FontMetrics fm = LuckInternalFrameTitlePane.this.frame.getFontMetrics(LuckInternalFrameTitlePane.this.getFont());
            String frameTitle = LuckInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = fm.stringWidth(frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            Dimension dim = new Dimension(width + 4, height);
            if (LuckInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = LuckInternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container c) {
            boolean leftToRight = LuckInternalFrameTitlePane.this.frame.getComponentOrientation().isLeftToRight();
            int w = LuckInternalFrameTitlePane.this.getWidth();
            Rectangle bound = c.getBounds();
            int startX = leftToRight ? 4 : w - 16 - 5;
            LuckInternalFrameTitlePane.this.menuBar.setBounds(startX, 4, 16, 16);
            int n = startX = leftToRight ? bound.width : 0;
            if (LuckInternalFrameTitlePane.this.frame.isClosable() && LuckInternalFrameTitlePane.this.closeButton.getIcon() != null) {
                int closeBtnW = LuckInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
                int closeBtnH = LuckInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
                startX = leftToRight ? startX - closeBtnW : startX;
                LuckInternalFrameTitlePane.this.closeButton.setBounds(startX, 0, closeBtnW, closeBtnH);
                int n2 = startX = leftToRight ? startX : startX + closeBtnW;
            }
            if (LuckInternalFrameTitlePane.this.frame.isMaximizable() && LuckInternalFrameTitlePane.this.maxButton.getIcon() != null) {
                int maximizeBtnW = LuckInternalFrameTitlePane.this.maxButton.getIcon().getIconWidth();
                int maximizeBtnH = LuckInternalFrameTitlePane.this.maxButton.getIcon().getIconHeight();
                startX = leftToRight ? startX - maximizeBtnW : startX;
                LuckInternalFrameTitlePane.this.maxButton.setBounds(startX, 0, maximizeBtnW, maximizeBtnH);
                int n3 = startX = leftToRight ? startX : startX + maximizeBtnW;
            }
            if (LuckInternalFrameTitlePane.this.frame.isIconifiable() && LuckInternalFrameTitlePane.this.iconButton.getIcon() != null) {
                int minBtnW = LuckInternalFrameTitlePane.this.iconButton.getIcon().getIconWidth();
                int minBtnH = LuckInternalFrameTitlePane.this.iconButton.getIcon().getIconHeight();
                startX = leftToRight ? startX - minBtnW : startX;
                LuckInternalFrameTitlePane.this.iconButton.setBounds(startX, 0, minBtnW, minBtnH);
            }
        }
    }
}

