/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.combobox;

import freeseawind.lf.utils.LuckUtils;
import freeseawind.swing.LuckList;
import freeseawind.swing.LuckScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;

public class LuckComboboxPopup
extends BasicComboPopup {
    private static final long serialVersionUID = -5046103803275794934L;

    public LuckComboboxPopup(JComboBox<?> combo) {
        super(combo);
    }

    @Override
    public void show() {
        this.comboBox.firePopupMenuWillBecomeVisible();
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        Point offset = (Point)UIManager.get("ComboBox.popLocation");
        this.show(this.comboBox, location.x + offset.x, location.y + offset.y);
    }

    @Override
    protected JScrollPane createScroller() {
        LuckScrollPane sp = new LuckScrollPane(this.list, 20, 31);
        ((JScrollPane)sp).setHorizontalScrollBar(null);
        return sp;
    }

    protected JList createList() {
        return new LuckList(this.comboBox.getModel()){
            private static final long serialVersionUID = 2418863980554774059L;

            @Override
            public void processMouseEvent(MouseEvent e) {
                if (LuckUtils.isMenuShortcutKeyDown(e)) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ toolkit.getMenuShortcutKeyMask(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0);
                }
                super.processMouseEvent(e);
            }
        };
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(UIManager.getBorder("ComboBox.poupBorder"));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }
}

