/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.combobox;

import freeseawind.lf.border.LuckBorderField;
import freeseawind.lf.border.LuckNinePatchBorder;
import freeseawind.lf.border.LuckShapeBorder;
import freeseawind.lf.cfg.LuckResourceBundle;
import freeseawind.lf.utils.LuckRes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComboBox;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class LuckComboBoxUIBundle
extends LuckResourceBundle {
    public static final String BACKGROUND = "ComboBox.background";
    public static final String SELECTIONBACKGROUND = "ComboBox.selectionBackground";
    public static final String SELECTIONFOREGROUND = "ComboBox.selectionForeground";
    public static final String BUTTONBACKGROUND = "ComboBox.buttonBackground";
    public static final String BUTTONFOCUS = "ComboBox.buttonFocus";
    public static final String BORDER = "ComboBox.border";
    public static final String POPUPBORDER = "ComboBox.poupBorder";
    public static final String RENDERERBORDER = "ComboBox.rendererBorder";
    public static final String ISFOCUSBORDER = "ComboBox.isFocusBorder";
    public static final String POPUPLOCATION = "ComboBox.popLocation";

    @Override
    public void uninitialize() {
        UIManager.put(BUTTONBACKGROUND, null);
        UIManager.put(BUTTONFOCUS, null);
        UIManager.put(POPUPBORDER, null);
        UIManager.put(RENDERERBORDER, null);
        UIManager.put(ISFOCUSBORDER, null);
        UIManager.put(POPUPLOCATION, null);
    }

    @Override
    protected void installColor(UIDefaults table) {
        table.put(BACKGROUND, this.getColorRes(Color.WHITE));
        table.put(SELECTIONBACKGROUND, this.getColorRes(0, 150, 201, 200));
        table.put(BUTTONBACKGROUND, this.getColorRes(Color.WHITE));
        table.put(BUTTONFOCUS, this.getColorRes(245, 171, 84));
        table.put(SELECTIONFOREGROUND, this.getColorRes(Color.WHITE));
    }

    @Override
    protected void installBorder(UIDefaults table) {
        Insets insets = new Insets(3, 4, 3, 4);
        table.put(BORDER, new LuckShapeBorder(insets){
            private static final long serialVersionUID = 8164006958194911458L;

            @Override
            public LuckBorderField getBorderField(Component c) {
                JComboBox combox = (JComboBox)c;
                if (combox.getUI() instanceof LuckBorderField) {
                    return (LuckBorderField)((Object)combox.getUI());
                }
                return null;
            }
        });
        BufferedImage img = LuckRes.getImage("popupmenu/shadow_border.9.png");
        UIManager.put(POPUPBORDER, this.getBorderRes(new LuckNinePatchBorder(new Insets(5, 3, 6, 3), img)));
        table.put(RENDERERBORDER, this.getBorderRes(new EmptyBorder(new Insets(0, 4, 0, 0))));
    }

    @Override
    protected void installOther(UIDefaults table) {
        table.put(POPUPLOCATION, new Point(0, 1));
        table.put(ISFOCUSBORDER, Boolean.TRUE);
    }
}

