/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.combobox;

import freeseawind.lf.basic.combobox.LuckComboBoxButton;
import freeseawind.lf.basic.combobox.LuckComboBoxRenderer;
import freeseawind.lf.basic.combobox.LuckComboboxPopup;
import freeseawind.lf.border.LuckBorderField;
import freeseawind.lf.border.LuckShapeBorder;
import freeseawind.lf.event.LuckBorderFocusHandle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class LuckComboBoxUI
extends BasicComboBoxUI
implements LuckBorderField {
    private LuckBorderFocusHandle handle;
    private RectangularShape contentShape;
    private RectangularShape borderShape;
    private boolean isFocusGained;
    private boolean isFocusBorder;

    public static ComponentUI createUI(JComponent c) {
        return new LuckComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(c, "opaque", Boolean.FALSE);
        if (c.getBorder() instanceof LuckShapeBorder) {
            this.installFocusListener(c);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallFocusListener(c);
        this.contentShape = null;
        this.borderShape = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.hasFocus = false;
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(g, r, this.hasFocus);
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        g.setColor(c.getBackground());
        Graphics2D g2d = (Graphics2D)g;
        if (this.contentShape != null) {
            this.contentShape.setFrame(0.0, 0.0, c.getWidth() - 1, c.getHeight() - 1);
            g2d.fill(this.contentShape);
        } else {
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    protected void installFocusListener(JComponent c) {
        this.handle = new LuckComboboxFocusHandle();
        this.isFocusBorder = UIManager.getBoolean("ComboBox.isFocusBorder");
        if (this.isFocusBorder) {
            this.contentShape = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f);
            this.borderShape = new RoundRectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f, 8.0f, 8.0f);
            c.addMouseListener(this.handle);
            c.addFocusListener(this.handle);
        }
    }

    protected void uninstallFocusListener(JComponent c) {
        if (this.handle != null) {
            c.removeMouseListener(this.handle);
            c.removeFocusListener(this.handle);
            this.handle = null;
        }
    }

    @Override
    protected JButton createArrowButton() {
        LuckComboBoxButton button = new LuckComboBoxButton(5){
            private static final long serialVersionUID = -7259590635997077859L;

            @Override
            public LuckBorderField getBorderField() {
                return LuckComboBoxUI.this;
            }

            @Override
            public JComponent getParentComp() {
                return LuckComboBoxUI.this.comboBox;
            }
        };
        button.setName("ComboBox.arrowButton");
        return button;
    }

    @Override
    protected ComboPopup createPopup() {
        return new LuckComboboxPopup((JComboBox<?>)this.comboBox);
    }

    protected ListCellRenderer<?> createRenderer() {
        return new LuckComboBoxRenderer();
    }

    @Override
    public void setFocusGained(boolean isFoucusGaind) {
        this.isFocusGained = isFoucusGaind;
    }

    @Override
    public boolean isFocusGaind() {
        return this.isFocusGained;
    }

    @Override
    public RectangularShape getBorderShape() {
        return this.borderShape;
    }

    public void setBorderShape(RectangularShape shape) {
        this.borderShape = shape;
    }

    public RectangularShape getContentShape() {
        return this.contentShape;
    }

    public void setContentShape(RectangularShape contentShape) {
        this.contentShape = contentShape;
    }

    public boolean isFocusBorder() {
        return this.isFocusBorder;
    }

    public class LuckComboboxFocusHandle
    extends LuckBorderFocusHandle {
        @Override
        protected void handleFocusLost() {
            if (this.getBorderField().isFocusGaind()) {
                this.getBorderField().setFocusGained(false);
                this.getComponent().repaint();
            }
        }

        @Override
        protected void handleFocusGained() {
            if (!this.getBorderField().isFocusGaind()) {
                this.getBorderField().setFocusGained(true);
                this.getComponent().repaint();
            }
        }

        @Override
        public JComponent getComponent() {
            return LuckComboBoxUI.this.comboBox;
        }

        @Override
        public LuckBorderField getBorderField() {
            return LuckComboBoxUI.this;
        }
    }
}

