/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf.basic.button;

import freeseawind.lf.basic.button.LuckButtonColorInfo;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;

public class LuckButtonUI
extends BasicButtonUI {
    private LuckButtonColorInfo btnColorInfo;
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent c) {
        return new LuckButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        LookAndFeel.installProperty(b, "rolloverEnabled", Boolean.TRUE);
        LookAndFeel.installProperty(b, "opaque", Boolean.FALSE);
        this.btnColorInfo = (LuckButtonColorInfo)UIManager.get("Button.colorInfo");
        if (b.getForeground() instanceof ColorUIResource) {
            b.setForeground(this.btnColorInfo.getFontColor());
        }
        this.listener = new ButtonPropertyChangeListener();
        b.addPropertyChangeListener(this.listener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removePropertyChangeListener(this.listener);
        this.btnColorInfo = null;
        this.listener = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        this.paintBg(g, (AbstractButton)c);
        if (model.isPressed() && model.isArmed() && b.getIcon() == null) {
            g.translate(2, 1);
        }
        super.paint(g, c);
        if (model.isPressed() && model.isArmed() && b.getIcon() == null) {
            g.translate(-2, -1);
        }
    }

    protected void paintBg(Graphics g, AbstractButton b) {
        if (!this.checkIsPaintBg(b)) {
            return;
        }
        int w = b.getWidth();
        int h = b.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (b.getModel().isPressed() && b.getModel().isArmed()) {
            g2d.setColor(this.btnColorInfo.getPressedColor());
        } else if (b.getModel().isRollover() && b.isRolloverEnabled()) {
            g2d.setColor(this.btnColorInfo.getRollverColor());
        } else {
            g2d.setColor(this.btnColorInfo.getNormalColor());
        }
        g2d.fillRoundRect(0, 0, w, h, 8, 8);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private boolean checkIsPaintBg(AbstractButton b) {
        if (!b.isContentAreaFilled()) {
            return false;
        }
        Object isPaintBg = b.getClientProperty("Button.isPaintBG");
        return b.getIcon() == null || isPaintBg != null;
    }

    public void setBtnColorInfo(LuckButtonColorInfo btnColorInfo) {
        this.btnColorInfo = btnColorInfo;
    }

    public class ButtonPropertyChangeListener
    implements PropertyChangeListener {
        private static final String CONTENTAREAFILLED = "contentAreaFilled";

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(CONTENTAREAFILLED)) {
                JButton btn = (JButton)evt.getSource();
                boolean isDefaultColor = btn.getForeground() instanceof ColorUIResource;
                if (!LuckButtonUI.this.checkIsPaintBg(btn) && isDefaultColor) {
                    btn.setForeground(UIManager.getColor("Button.foreground"));
                } else {
                    btn.setForeground(LuckButtonUI.this.btnColorInfo.getFontColor());
                }
            }
        }
    }
}

