/*
 * Decompiled with CFR 0.152.
 */
package freeseawind.lf;

import freeseawind.lf.cfg.LuckResConfig;
import freeseawind.lf.cfg.LuckResConfigImpl;
import freeseawind.lf.cfg.LuckUIConfig;
import freeseawind.lf.cfg.LuckUIConfigImpl;
import freeseawind.lf.utils.LuckPlatformUtils;
import java.awt.Font;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LittleLuckLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = -7537863322955102478L;
    private static final String BUNDLENAME = "com.github.freeseawind.littleluck";
    private LuckUIConfig uiConfig;
    private LuckResConfig resConfig;

    public LittleLuckLookAndFeel() {
        this.initConfig();
        this.setPlatformFont();
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        UIManager.getDefaults().removeResourceBundle(BUNDLENAME);
        this.resConfig.removeResource();
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        this.initResourceBundle(table);
        if (this.resConfig != null) {
            this.resConfig.loadResources(table);
        }
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        if (this.uiConfig != null) {
            this.uiConfig.initClassDefaults(table);
        }
    }

    protected void initResourceBundle(UIDefaults table) {
        table.addResourceBundle(BUNDLENAME);
    }

    public static void initLookAndFeelParam() {
        System.setProperty("sun.java2d.noddraw", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
    }

    public void setPlatformFont() {
        if (LuckPlatformUtils.isWindows()) {
            String fontName = "Microsoft YaHei";
            this.setApplicationFont(new Font(fontName, 0, 12));
        }
    }

    public void initConfig() {
        if (this.uiConfig == null) {
            this.uiConfig = new LuckUIConfigImpl();
        }
        if (this.resConfig == null) {
            this.resConfig = new LuckResConfigImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationFont(Font f) {
        UIDefaults defaults;
        UIDefaults uIDefaults = defaults = UIManager.getLookAndFeelDefaults();
        synchronized (uIDefaults) {
            for (Object ui_property : defaults.keySet()) {
                if (!ui_property.toString().endsWith(".font")) continue;
                UIManager.put(ui_property, f);
            }
        }
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    public String getName() {
        return "LittleLuckLookAndFeel";
    }

    @Override
    public String getDescription() {
        return "The LittleLuck cross platform Look and Feel";
    }

    @Override
    public String getID() {
        return "LittleLuck";
    }

    static {
        LittleLuckLookAndFeel.initLookAndFeelParam();
    }
}

