/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.util;

@Deprecated
public class RingBufferHigh {
    private static final int DEFAULT_SIZE = 1024;
    private byte[] data;
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    public RingBufferHigh() {
        this(1024);
    }

    public RingBufferHigh(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        if (Integer.bitCount(bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.data = new byte[bufferSize];
    }

    public final int getCapacity() {
        return this.data.length - 1;
    }

    public final int getSize() {
        return this.size;
    }

    private int getMode(int num) {
        return num & this.data.length - 1;
    }

    private Boolean isEmpty() {
        return this.head == this.tail;
    }

    private Boolean isFull() {
        return this.getMode(this.tail + 1) == this.head;
    }

    public void put(byte v) {
        if (this.isFull().booleanValue()) {
            this.reSize(this.data.length << 1);
        }
        this.data[this.tail] = v;
        this.tail = this.getMode(this.tail + 1);
        ++this.size;
    }

    public void put(byte[] vs) {
        for (byte v : vs) {
            this.put(v);
        }
    }

    public byte get() throws IllegalAccessException {
        if (this.isEmpty().booleanValue()) {
            throw new IllegalAccessException("Cannot get from ring buffer.");
        }
        byte result = this.data[this.head];
        this.head = this.getMode(this.head + 1);
        --this.size;
        return result;
    }

    public byte[] getAll() {
        if (this.isEmpty().booleanValue()) {
            new IllegalAccessException("Cannot get from ring buffer.");
        }
        byte[] newData = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.data[this.getMode(this.head + i)];
        }
        this.head = this.getMode(this.head + this.size);
        this.size = 0;
        return newData;
    }

    public byte read(int index) {
        if (this.isEmpty().booleanValue()) {
            new IllegalAccessException("Cannot get from ring buffer.");
        }
        if (index >= this.size) {
            new IllegalAccessException("Parameter range error.");
        }
        return this.data[this.getMode(this.head + index)];
    }

    public byte[] read(int from, int to) {
        if (this.isEmpty().booleanValue()) {
            new IllegalAccessException("Cannot get from ring buffer.");
        }
        if (from >= to) {
            new IllegalAccessException("'from' must be less than 'to'.");
        }
        if (from < 0 || to > this.size) {
            new IllegalAccessException("Parameter range error.");
        }
        byte[] result = new byte[to - from];
        for (int i = 0; i < result.length; ++i) {
            int index = this.getMode(this.head + from + i);
            result[i] = this.data[index];
        }
        return result;
    }

    public void del(int dsize) {
        if (this.isEmpty().booleanValue()) {
            new IllegalAccessException("Cannot get from ring buffer.");
        }
        if (dsize > this.size) {
            new IllegalAccessException("Parameter dsize range error.");
        }
        this.head = this.getMode(this.head + dsize);
        this.size -= dsize;
    }

    public void reSize(int capacity) {
        byte[] newData = new byte[capacity];
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.data[this.getMode(this.head + i)];
        }
        this.data = newData;
        this.head = 0;
        this.tail = this.size;
    }
}

