/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.util;

public class RingBuffer {
    private static final int DEFAULT_SIZE = 1024;
    private byte[] data;
    private int size = 0;
    private int head = 0;
    private int tail = 0;

    public RingBuffer() {
        this(1024);
    }

    public RingBuffer(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        if (Integer.bitCount(bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.data = new byte[bufferSize];
    }

    public final int getCapacity() {
        return this.data.length - 1;
    }

    public final int getSize() {
        return this.size;
    }

    private int getMode(int num) {
        return num & this.data.length - 1;
    }

    private Boolean isEmpty() {
        return this.head == this.tail;
    }

    private Boolean isFull() {
        return this.getMode(this.tail + 1) == this.head;
    }

    public void reSize(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity must not be less than 0");
        }
        if (Integer.bitCount(capacity) != 1) {
            throw new IllegalArgumentException("capacity must be a power of 2");
        }
        byte[] newData = new byte[capacity];
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.data[this.getMode(this.head + i)];
        }
        this.data = newData;
        this.head = 0;
        this.tail = this.size;
    }

    public boolean add(byte v) {
        if (this.isFull().booleanValue()) {
            this.reSize(this.data.length << 1);
        }
        this.data[this.tail] = v;
        this.tail = this.getMode(this.tail + 1);
        ++this.size;
        return true;
    }

    public boolean add(byte[] vs) {
        for (byte v : vs) {
            this.add(v);
        }
        return true;
    }

    public Byte get() {
        if (this.isEmpty().booleanValue()) {
            return null;
        }
        byte result = this.data[this.head];
        this.head = this.getMode(this.head + 1);
        --this.size;
        return result;
    }

    public byte[] getAll() {
        if (this.isEmpty().booleanValue()) {
            return null;
        }
        byte[] newData = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.data[this.getMode(this.head + i)];
        }
        this.head = this.getMode(this.head + this.size);
        this.size = 0;
        return newData;
    }

    public Byte read(int index) {
        if (this.isEmpty().booleanValue()) {
            return null;
        }
        if (index >= this.size) {
            return null;
        }
        return this.data[this.getMode(this.head + index)];
    }

    public byte[] read(int from, int to) {
        if (this.isEmpty().booleanValue()) {
            return null;
        }
        if (from >= to) {
            return null;
        }
        if (from < 0 || to > this.size) {
            return null;
        }
        byte[] result = new byte[to - from];
        for (int i = 0; i < result.length; ++i) {
            int index = this.getMode(this.head + from + i);
            result[i] = this.data[index];
        }
        return result;
    }

    public boolean del(int size) {
        if (this.isEmpty().booleanValue()) {
            return false;
        }
        if (size > this.size) {
            size = this.size;
        }
        this.head = this.getMode(this.head + size);
        this.size -= size;
        return true;
    }
}

