/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.util;

import com.tracker.util.ArrayUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Convert {
    private static final String NULLSTR = "";

    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String toStrNoEmpty(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            if (value.toString().isEmpty()) {
                return defaultValue;
            }
            return (String)value;
        }
        return value.toString();
    }

    public static String toStr(Object value) {
        return Convert.toStr(value, null);
    }

    public static Character toChar(Object value, Character defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        String valueStr = Convert.toStr(value, null);
        return Character.valueOf(Convert.isEmpty(valueStr) ? defaultValue.charValue() : valueStr.charAt(0));
    }

    public static Character toChar(Object value) {
        return Convert.toChar(value, null);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Byte toByte(Object value) {
        return Convert.toByte(value, null);
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Short.parseShort(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Short toShort(Object value) {
        return Convert.toShort(value, null);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return NumberFormat.getInstance().parse(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Number toNumber(Object value) {
        return Convert.toNumber(value, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer toInt(Object value) {
        return Convert.toInt(value, null);
    }

    public static Integer[] toIntArray(String str) {
        return Convert.toIntArray(",", str);
    }

    public static Long[] toLongArray(String str) {
        return Convert.toLongArray(",", str);
    }

    public static Integer[] toIntArray(String split, String str) {
        if (Convert.isEmpty(str)) {
            return new Integer[0];
        }
        String[] arr = str.split(split);
        Integer[] ints = new Integer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Integer v;
            ints[i] = v = Convert.toInt(arr[i], 0);
        }
        return ints;
    }

    public static Long[] toLongArray(String split, String str) {
        if (Convert.isEmpty(str)) {
            return new Long[0];
        }
        String[] arr = str.split(split);
        Long[] longs = new Long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Long v;
            longs[i] = v = Convert.toLong(arr[i], null);
        }
        return longs;
    }

    public static byte[] toByteArray(String split, String str) {
        if (Convert.isEmpty(str)) {
            return new byte[0];
        }
        String[] arr = str.split(split);
        byte[] bytes = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(arr[i], 10);
        }
        return bytes;
    }

    public static String[] toStrArray(String str) {
        return Convert.toStrArray(",", str);
    }

    public static String[] toStrArray(String split, String str) {
        return str.split(split);
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long toLong(Object value) {
        return Convert.toLong(value, null);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double toDouble(Object value) {
        return Convert.toDouble(value, null);
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(valueStr.trim()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float toFloat(Object value) {
        return Convert.toFloat(value, null);
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        switch (valueStr = valueStr.trim().toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "yes": {
                return true;
            }
            case "ok": {
                return true;
            }
            case "no": {
                return false;
            }
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        return defaultValue;
    }

    public static Boolean toBool(Object value) {
        return Convert.toBool(value, null);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigInteger toBigInteger(Object value) {
        return Convert.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        String valueStr = Convert.toStr(value, null);
        if (Convert.isEmpty(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Convert.toBigDecimal(value, null);
    }

    public static String utf8Str(Object obj) {
        return Convert.str(obj, StandardCharsets.UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return Convert.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return Convert.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            byte[] bytes = ArrayUtils.toPrimitive((Byte[])obj);
            return Convert.str(bytes, charset);
        }
        if (obj instanceof ByteBuffer) {
            return Convert.str((ByteBuffer)obj, charset);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return Convert.str(bytes, Convert.isEmpty(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return Convert.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static boolean isEmpty(String str) {
        return Convert.isNull(str) || NULLSTR.equals(str.trim());
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static Map<String, Object> objectToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static String mapToJsonString(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("\"").append(entry.getKey()).append("\":");
            Object value = entry.getValue();
            if (value instanceof String) {
                sb.append("\"").append(value).append("\"");
            } else if (value instanceof Map) {
                Map node2 = (Map)value;
                sb.append(Convert.mapToJsonString(node2));
            } else if (value instanceof List) {
                List list = (List)value;
                sb.append("[");
                list.stream().forEach(node -> sb.append(Convert.mapToJsonString(node)).append(","));
                sb.deleteCharAt(sb.length() - 1);
                sb.append("]");
            } else {
                sb.append(value);
            }
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }
}

