/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.util;

import com.tracker.ev07b.ProtocolUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BytesHexStrUtil {
    private static final String HEX_CHAR = "0123456789ABCDEF";

    public static String bytes2StringByASCII(byte[] data) {
        StringBuilder sbu = new StringBuilder();
        for (byte datum : data) {
            sbu.append((char)(datum & 0xFF));
        }
        return sbu.toString();
    }

    public static String bytes2StringByUTF_8(byte[] data) {
        return new String(data, StandardCharsets.UTF_8);
    }

    public static String bytes2String(byte[] data, Charset charset) {
        return new String(data, charset);
    }

    public static byte[] string2BytesByASCII(String data) {
        return data.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] string2BytesByUTF_8(String data) {
        return data.getBytes(StandardCharsets.UTF_8);
    }

    public static String bytesToHexString(byte[] byteArray) {
        return BytesHexStrUtil.bytesToHexString(byteArray, true);
    }

    public static String bytesToHexString(byte[] byteArray, boolean isOrder) {
        StringBuilder stringBuilder = new StringBuilder();
        if (byteArray == null || byteArray.length <= 0) {
            return null;
        }
        if (isOrder) {
            for (int i = 0; i < byteArray.length; ++i) {
                stringBuilder.append(String.format("%02X", byteArray[i])).append(" ");
            }
        } else {
            for (int i = byteArray.length - 1; i >= 0; --i) {
                stringBuilder.append(String.format("%02X", byteArray[i])).append(" ");
            }
        }
        return stringBuilder.toString().trim();
    }

    public static String longToHexString(long v, int l) {
        byte[] array = ProtocolUtil.long2Bytes(v, l);
        return BytesHexStrUtil.bytesToHexString(array);
    }

    public static byte[] hexStringToBytes(String hexString) {
        return BytesHexStrUtil.hexStringToBytes(hexString, true);
    }

    public static byte[] hexStringToBytes(String hexString, boolean isOrder) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.replaceAll(" ", "");
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        if (isOrder) {
            for (int i = 0; i < length; ++i) {
                int pos = i * 2;
                d[i] = (byte)(BytesHexStrUtil.charToByte(hexChars[pos]) << 4 | BytesHexStrUtil.charToByte(hexChars[pos + 1]));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                int pos = (length - 1 - i) * 2;
                d[i] = (byte)(BytesHexStrUtil.charToByte(hexChars[pos]) << 4 | BytesHexStrUtil.charToByte(hexChars[pos + 1]));
            }
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)HEX_CHAR.indexOf(c);
    }

    @Deprecated
    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = HEX_CHAR.toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int i = 0; i < byteArray.length; ++i) {
            int v = byteArray[i] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @Deprecated
    public static byte[] hexStrToByteArray(String hexStr) {
        if (hexStr == null) {
            return null;
        }
        if ((hexStr = hexStr.replaceAll(" ", "")).length() == 0) {
            return new byte[0];
        }
        byte[] byteArray = new byte[hexStr.length() / 2];
        for (int i = 0; i < byteArray.length; ++i) {
            String subStr = hexStr.substring(2 * i, 2 * i + 2);
            byteArray[i] = (byte)Integer.parseInt(subStr, 16);
        }
        return byteArray;
    }
}

