/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.event;

import com.tracker.event.RD_Condition;
import com.tracker.event.RD_Observable;
import com.tracker.event.RD_Observer;
import com.tracker.event.RD_ObserverCallBack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReturnDataUtil {
    private static Map<String, RD_Observable<Object>> observableMap = new HashMap<String, RD_Observable<Object>>();

    private static RD_Observable<Object> getObservable(String observableKey) {
        if (observableMap.containsKey(observableKey)) {
            return observableMap.get(observableKey);
        }
        RD_Observable<Object> observable = new RD_Observable<Object>();
        observableMap.put(observableKey, observable);
        return observable;
    }

    private static List<RD_Observable<Object>> getObservable(String[] keyList) {
        ArrayList<RD_Observable<Object>> observableList = new ArrayList<RD_Observable<Object>>();
        for (String key : keyList) {
            RD_Observable<Object> observable = ReturnDataUtil.getObservable(key);
            observableList.add(observable);
        }
        return observableList;
    }

    public static void setObservableData(String observableKey, String channel, Object data) {
        RD_Condition condition = new RD_Condition().setChannel(channel);
        ReturnDataUtil.setObservableData(observableKey, condition, data);
    }

    public static void setObservableData(String observableKey, RD_Condition condition, Object data) {
        ReturnDataUtil.getObservable(observableKey).setCondition(condition).setData(data);
    }

    public static <T> T getObserverData(String observableKey, String channel, long timeOut) {
        RD_Condition condition = new RD_Condition().setChannel(channel);
        return ReturnDataUtil.getObserverData(observableKey, condition, timeOut);
    }

    public static <T> T getObserverData(String observableKey, RD_Condition condition, long timeOut) {
        RD_Observer observer = new RD_Observer(ReturnDataUtil.getObservable(observableKey), condition);
        return (T)observer.getData(timeOut);
    }

    public static RD_ObserverCallBack getObserverData(String observableKey, RD_ObserverCallBack.CallBack callBack) {
        return new RD_ObserverCallBack(ReturnDataUtil.getObservable(observableKey), callBack);
    }

    public static RD_ObserverCallBack getObserverData(String[] keyList, RD_ObserverCallBack.CallBack callBack) {
        return new RD_ObserverCallBack(ReturnDataUtil.getObservable(keyList), callBack);
    }

    public static void deleteObserverData(String observableKey, RD_ObserverCallBack observer) {
        observer.deleteObserver(ReturnDataUtil.getObservable(observableKey));
    }
}

