/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyWifi2
implements AnalysisKey<Map<String, Object>> {
    public static KeyWifi2 INSTANCE = new KeyWifi2();

    private KeyWifi2() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> map_wifi = new HashMap<String, Object>(1);
        ArrayList wifiList = new ArrayList();
        int i = 0;
        while (i + 7 < data.length) {
            HashMap<String, Object> node = new HashMap<String, Object>(3);
            int rssi = ProtocolUtil.bytes2Int(data[i], true);
            String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(data, i + 1, i + 7), true);
            node.put("signal", rssi);
            node.put("mac", mac);
            int nameLength = data[i + 7] & 0xFF;
            String name = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(data, i + 8, i + 8 + nameLength));
            node.put("name", name);
            wifiList.add(node);
            i += 8 + nameLength;
        }
        map_wifi.put("wifiList", wifiList);
        return map_wifi;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        byte[] data_wifi = null;
        List wifiList = (List)data.get("wifiList");
        for (Map wifi : wifiList) {
            int signal = Convert.toInt(wifi.get("signal"), 0);
            String mac = Convert.toStr(wifi.get("mac"), "00:00:00:00:00:00");
            data_wifi = ArrayUtils.addAll(data_wifi, (byte)signal);
            data_wifi = ArrayUtils.addAll(data_wifi, ProtocolUtil.mac2Bytes(mac, true));
            String name = Convert.toStr(wifi.get("name"));
            if (name == null) continue;
            data_wifi = ArrayUtils.addAll(data_wifi, (byte)name.length());
            data_wifi = ArrayUtils.addAll(data_wifi, BytesHexStrUtil.string2BytesByUTF_8(name));
        }
        return data_wifi;
    }
}

