/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class KeyStepData
implements AnalysisKey<Map<String, Object>> {
    public static KeyStepData INSTANCE = new KeyStepData();

    private KeyStepData() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> stepData = new HashMap<String, Object>(4);
        Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, 0, 4));
        int stepTotal = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 4, 8));
        int stepTime = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 8, 10));
        int stepCount = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 10, 12));
        stepData.put("dateTime", new Timestamp(dateTime.getTime()));
        stepData.put("stepTotal", stepTotal);
        stepData.put("stepTime", stepTime);
        stepData.put("stepCount", stepCount);
        return stepData;
    }

    @Override
    public byte[] decode(Map<String, Object> stepData) {
        byte[] dateTime = ProtocolUtil.dateTime2Bytes(stepData.get("dateTime"));
        int stepTotal = Convert.toInt(stepData.get("stepTotal"), 0);
        int stepTime = Convert.toInt(stepData.get("stepTime"), 0);
        int stepCount = Convert.toInt(stepData.get("stepCount"), 0);
        byte[] data_step = ArrayUtils.addAll(dateTime, ProtocolUtil.long2Bytes(stepTotal, 4));
        data_step = ArrayUtils.addAll(data_step, ProtocolUtil.long2Bytes(stepTime, 2));
        data_step = ArrayUtils.addAll(data_step, ProtocolUtil.long2Bytes(stepCount, 2));
        return data_step;
    }
}

