/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyStep
implements AnalysisKey<List<Map>> {
    public static KeyStep INSTANCE = new KeyStep();

    private KeyStep() {
    }

    @Override
    public List<Map> encode(byte[] data) {
        ArrayList<Map> stepList = new ArrayList<Map>();
        for (int i = 0; i < data.length; i += 8) {
            HashMap<String, Comparable<Date>> ev07b_step = new HashMap<String, Comparable<Date>>(2);
            Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, i, i + 4));
            int step = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, i + 4, i + 8));
            ev07b_step.put("dateTime", new Timestamp(dateTime.getTime()));
            ev07b_step.put("step", Integer.valueOf(step));
            stepList.add(ev07b_step);
        }
        return stepList;
    }

    @Override
    public byte[] decode(List<Map> dataList) {
        byte[] data_step = null;
        for (Map step : dataList) {
            int stepNo = Convert.toInt(step.get("step"), 0);
            byte[] stepBytes = ProtocolUtil.dateTime2Bytes(step.get("dateTime"));
            data_step = ArrayUtils.addAll(data_step, stepBytes);
            data_step = ArrayUtils.addAll(data_step, ProtocolUtil.long2Bytes(stepNo, 4));
        }
        return data_step;
    }
}

