/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class KeyStatus
implements AnalysisKey<Map<String, Object>> {
    public static KeyStatus INSTANCE = new KeyStatus();

    private KeyStatus() {
    }

    public static Map<String, Object> getDeviceStatus(byte[] status) {
        long flag = ProtocolUtil.bytes2Long(Arrays.copyOfRange(status, 0, 4));
        boolean isGPS = ProtocolUtil.getbit(flag, 0, 1) > 0;
        boolean isWIFI = ProtocolUtil.getbit(flag, 1, 2) > 0;
        boolean isGMS = ProtocolUtil.getbit(flag, 2, 3) > 0;
        boolean isBLE = ProtocolUtil.getbit(flag, 3, 4) > 0;
        boolean isCharging = ProtocolUtil.getbit(flag, 4, 5) > 0;
        boolean isChargingComplete = ProtocolUtil.getbit(flag, 5, 6) > 0;
        boolean isReboot = ProtocolUtil.getbit(flag, 6, 7) > 0;
        boolean isHistoricalData = ProtocolUtil.getbit(flag, 7, 8) > 0;
        boolean isAGPS = ProtocolUtil.getbit(flag, 8, 9) > 0;
        boolean isMotion = ProtocolUtil.getbit(flag, 9, 10) > 0;
        boolean isSmart = ProtocolUtil.getbit(flag, 10, 11) > 0;
        boolean isHomeBeacon = ProtocolUtil.getbit(flag, 11, 12) > 0;
        boolean bleConnected = ProtocolUtil.getbit(flag, 12, 13) > 0;
        int fallDownStatus = ProtocolUtil.getbit(flag, 13, 14);
        boolean isHomeWifi = ProtocolUtil.getbit(flag, 14, 15) > 0;
        boolean isHome = ProtocolUtil.getbit(flag, 15, 16) > 0;
        int workMode = ProtocolUtil.getbit(flag, 16, 19);
        int signalSize = ProtocolUtil.getbit(flag, 19, 24);
        int battery = ProtocolUtil.getbit(flag, 24, 32);
        HashMap<String, Object> deviceStatus = new HashMap<String, Object>();
        if (isBLE) {
            deviceStatus.put("dataType", "BLE");
        } else if (isSmart) {
            deviceStatus.put("dataType", "Smart");
        } else if (isHomeBeacon) {
            deviceStatus.put("dataType", "HomeBeacon");
        } else if (isHomeWifi) {
            deviceStatus.put("dataType", "HomeWifi");
        } else if (isGPS) {
            deviceStatus.put("dataType", "GPS");
        } else if (isWIFI && isGMS) {
            deviceStatus.put("dataType", "WIFI&GSM");
        } else if (isWIFI) {
            deviceStatus.put("dataType", "WIFI");
        } else if (isGMS) {
            deviceStatus.put("dataType", "GSM");
        }
        deviceStatus.put("isGPS", isGPS);
        deviceStatus.put("isWIFI", isWIFI);
        deviceStatus.put("isGSM", isGMS);
        deviceStatus.put("isBLE", isBLE);
        deviceStatus.put("isSmart", isSmart);
        deviceStatus.put("isHomeBeacon", isHomeBeacon);
        deviceStatus.put("isHomeWifi", isHomeWifi);
        deviceStatus.put("isCharging", isCharging);
        deviceStatus.put("isChargingComplete", isChargingComplete);
        deviceStatus.put("isHistoricalData", isHistoricalData);
        deviceStatus.put("isReboot", isReboot);
        deviceStatus.put("isAGPS", isAGPS);
        deviceStatus.put("isMotion", isMotion);
        deviceStatus.put("workMode", workMode);
        deviceStatus.put("signalSize", signalSize);
        deviceStatus.put("battery", battery);
        deviceStatus.put("isHome", isHome);
        deviceStatus.put("bleConnected", bleConnected);
        deviceStatus.put("fallDownStatus", fallDownStatus);
        return deviceStatus;
    }

    public static Map<String, Object> getDeviceStatus2(byte[] status) {
        long flag = ProtocolUtil.bytes2Long(Arrays.copyOfRange(status, 0, 4));
        int network = ProtocolUtil.getbit(flag, 0, 3);
        int wifiConnected = ProtocolUtil.getbit(flag, 3, 4);
        int wifiUpload = ProtocolUtil.getbit(flag, 4, 5);
        int volte = ProtocolUtil.getbit(flag, 5, 6);
        int calling = ProtocolUtil.getbit(flag, 6, 7);
        boolean isBeacon = ProtocolUtil.getbit(flag, 16, 17) > 0;
        HashMap<String, Object> deviceStatus = new HashMap<String, Object>(5);
        deviceStatus.put("network", network);
        deviceStatus.put("wifiConnected", wifiConnected);
        deviceStatus.put("wifiUpload", wifiUpload);
        deviceStatus.put("volte", volte);
        deviceStatus.put("calling", calling);
        deviceStatus.put("isBeacon", isBeacon);
        return deviceStatus;
    }

    public static Map<String, Boolean> getDataType(byte[] status) {
        long flag = ProtocolUtil.bytes2Long(Arrays.copyOfRange(status, 0, 4));
        boolean isGPS = ProtocolUtil.getbit(flag, 0, 1) > 0;
        boolean isWIFI = ProtocolUtil.getbit(flag, 1, 2) > 0;
        boolean isGMS = ProtocolUtil.getbit(flag, 2, 3) > 0;
        boolean isBLE = ProtocolUtil.getbit(flag, 3, 4) > 0;
        boolean isSmart = ProtocolUtil.getbit(flag, 10, 11) > 0;
        boolean isHomeBeacon = ProtocolUtil.getbit(flag, 11, 12) > 0;
        boolean isHomeWifi = ProtocolUtil.getbit(flag, 14, 15) > 0;
        HashMap<String, Boolean> dataType = new HashMap<String, Boolean>();
        dataType.put("isGPS", isGPS);
        dataType.put("isWIFI", isWIFI);
        dataType.put("isGSM", isGMS);
        dataType.put("isBLE", isBLE);
        dataType.put("isSmart", isSmart);
        dataType.put("isHomeBeacon", isHomeBeacon);
        dataType.put("isHomeWifi", isHomeWifi);
        if (status.length > 4) {
            long flag2 = ProtocolUtil.bytes2Long(Arrays.copyOfRange(status, 4, 8));
            boolean isBeacon = ProtocolUtil.getbit(flag2, 16, 17) > 0;
            dataType.put("isBeacon", isBeacon);
        }
        return dataType;
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, 0, 4));
        byte[] status = Arrays.copyOfRange(data, 4, 8);
        long statusCode = ProtocolUtil.bytes2Long(status);
        HashMap<String, Object> map_status = new HashMap<String, Object>(5);
        map_status.put("dateTime", new Timestamp(dateTime.getTime()));
        map_status.put("deviceStatus", KeyStatus.getDeviceStatus(status));
        map_status.put("statusCode", statusCode);
        if (data.length > 8) {
            byte[] status2 = Arrays.copyOfRange(data, 8, 12);
            map_status.put("deviceStatus2", KeyStatus.getDeviceStatus2(status2));
            map_status.put("statusCode", ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 4, 12)));
        }
        return map_status;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        Map deviceStatus = (Map)data.get("deviceStatus");
        long deviceStatusCode = Convert.toInt(deviceStatus.get("isGPS"), 0).intValue();
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isWIFI"), 0) << 1);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isGSM"), 0) << 2);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isBLE"), 0) << 3);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isCharging"), 0) << 4);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isChargingComplete"), 0) << 5);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isReboot"), 0) << 6);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isHistoricalData"), 0) << 7);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isAGPS"), 0) << 8);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isMotion"), 0) << 9);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isSmart"), 0) << 10);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isHomeBeacon"), 0) << 11);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("bleConnected"), 0) << 12);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("fallDownStatus"), 0) << 13);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isHomeWifi"), 0) << 14);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("isHome"), 0) << 15);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("workMode"), 0) << 16);
        deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("signalSize"), 0) << 19);
        byte[] data_status = ProtocolUtil.dateTime2Bytes(data.get("dateTime"));
        data_status = ArrayUtils.addAll(data_status, ProtocolUtil.long2Bytes(deviceStatusCode |= (long)(Convert.toInt(deviceStatus.get("battery"), 0) << 24), 4));
        Map deviceStatus2 = (Map)data.get("deviceStatus2");
        if (deviceStatus2 != null) {
            long statusCode2 = Convert.toInt(deviceStatus2.get("network"), 0).intValue();
            statusCode2 |= (long)(Convert.toInt(deviceStatus2.get("wifiConnected"), 0) << 3);
            statusCode2 |= (long)(Convert.toInt(deviceStatus2.get("wifiUpload"), 0) << 4);
            statusCode2 |= (long)(Convert.toInt(deviceStatus2.get("volte"), 0) << 5);
            statusCode2 |= (long)(Convert.toInt(deviceStatus2.get("calling"), 0) << 6);
            data_status = ArrayUtils.addAll(data_status, ProtocolUtil.long2Bytes(statusCode2 |= (long)(Convert.toInt(deviceStatus2.get("isBeacon"), 0) << 16), 4));
        }
        return data_status;
    }
}

