/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KeySmart
implements AnalysisKey<Map<String, Object>> {
    public static KeySmart INSTANCE = new KeySmart();

    private KeySmart() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> map_ble = new HashMap<String, Object>(4);
        double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 0, 4));
        double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 4, 8));
        int radius = data[8] & 0xFF | (data[9] & 0xFF) << 8;
        long height = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 10, 12), true);
        map_ble.put("lat", lat);
        map_ble.put("lng", lng);
        map_ble.put("radius", Double.valueOf(radius));
        map_ble.put("height", Double.valueOf(height));
        return map_ble;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        double lat = Convert.toDouble(data.get("lat"), 0.0);
        double lng = Convert.toDouble(data.get("lng"), 0.0);
        long radius = Convert.toLong(data.get("radius"), 0L);
        long height = Convert.toLong(data.get("height"), 0L);
        byte[] data_smart = ProtocolUtil.latlng2Bytes(lat, lng);
        data_smart = ArrayUtils.addAll(data_smart, ProtocolUtil.long2Bytes(radius, 2));
        data_smart = ArrayUtils.addAll(data_smart, ProtocolUtil.long2Bytes(height, 2));
        return data_smart;
    }
}

