/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeySPO2List
implements AnalysisKey<List<Map>> {
    public static KeySPO2List INSTANCE = new KeySPO2List();

    private KeySPO2List() {
    }

    @Override
    public List<Map> encode(byte[] data) {
        ArrayList<Map> ev07b_spo2_list = new ArrayList<Map>();
        for (int i = 0; i < data.length; i += 6) {
            HashMap<String, Comparable<Date>> ev07b_spo2 = new HashMap<String, Comparable<Date>>(3);
            Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, i, i + 4));
            int heartRate = data[i + 4] & 0xFF;
            int trustLevel = data[i + 5] & 0xFF;
            ev07b_spo2.put("dateTime", new Timestamp(dateTime.getTime()));
            ev07b_spo2.put("spo2Rate", Integer.valueOf(heartRate));
            ev07b_spo2.put("trustLevel", Integer.valueOf(trustLevel));
            ev07b_spo2_list.add(ev07b_spo2);
        }
        return ev07b_spo2_list;
    }

    @Override
    public byte[] decode(List<Map> dataList) {
        byte[] data_spo2Rate = null;
        for (Map spo2Rate : dataList) {
            byte spo2RateNo = Convert.toByte(spo2Rate.get("spo2Rate"), (byte)0);
            byte trustLevel = Convert.toByte(spo2Rate.get("trustLevel"), (byte)0);
            byte[] spo2RateBytes = ProtocolUtil.dateTime2Bytes(spo2Rate.get("dateTime"));
            data_spo2Rate = ArrayUtils.addAll(data_spo2Rate, spo2RateBytes);
            data_spo2Rate = ArrayUtils.addAll(data_spo2Rate, spo2RateNo, trustLevel);
        }
        return data_spo2Rate;
    }
}

