/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyIBeacon
implements AnalysisKey<Map<String, Object>> {
    public static KeyIBeacon INSTANCE = new KeyIBeacon();

    private KeyIBeacon() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> ev07b_beacon = new HashMap<String, Object>(4);
        Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, 0, 4));
        long companyId = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 4, 6));
        String uuid = BytesHexStrUtil.bytesToHexString(Arrays.copyOfRange(data, 6, 22));
        ev07b_beacon.put("dateTime", dateTime);
        ev07b_beacon.put("companyId", companyId);
        ev07b_beacon.put("uuid", uuid);
        ArrayList ev07b_beacon_list = new ArrayList();
        for (int i = 22; i < data.length; i += 6) {
            HashMap<String, Number> beacon = new HashMap<String, Number>();
            long major = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, i, i + 2));
            long minor = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, i + 2, i + 4));
            int rssi_m = ProtocolUtil.bytes2Int(data[i + 4], true);
            int rssi_r = ProtocolUtil.bytes2Int(data[i + 5], true);
            beacon.put("major", major);
            beacon.put("minor", minor);
            beacon.put("rssi_m", rssi_m);
            beacon.put("rssi_r", rssi_r);
            ev07b_beacon_list.add(beacon);
        }
        ev07b_beacon.put("list", ev07b_beacon_list);
        return ev07b_beacon;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        long companyId = Convert.toLong(data.get("companyId"));
        String uuid = Convert.toStr(data.get("uuid"));
        uuid = ProtocolUtil.strAfterFillZero(uuid, 32);
        byte[] beaconListBytes = ProtocolUtil.dateTime2Bytes(data.get("dateTime"));
        beaconListBytes = ArrayUtils.addAll(beaconListBytes, ProtocolUtil.long2Bytes(companyId, 2));
        beaconListBytes = ArrayUtils.addAll(beaconListBytes, BytesHexStrUtil.hexStringToBytes(uuid));
        byte[] listByte = null;
        List list = (List)data.get("list");
        for (Map beacon : list) {
            long major = Convert.toInt(beacon.get("major")).intValue();
            long minor = Convert.toInt(beacon.get("minor")).intValue();
            byte rssi_m = Convert.toByte(beacon.get("rssi_m"), (byte)0);
            byte rssi_r = Convert.toByte(beacon.get("rssi_r"), (byte)0);
            listByte = ArrayUtils.addAll(listByte, ProtocolUtil.long2Bytes(major, 2));
            listByte = ArrayUtils.addAll(listByte, ProtocolUtil.long2Bytes(minor, 2));
            listByte = ArrayUtils.addAll(listByte, rssi_m, rssi_r);
        }
        beaconListBytes = ArrayUtils.addAll(beaconListBytes, listByte);
        return beaconListBytes;
    }
}

