/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KeyHomeWifi
implements AnalysisKey<Map<String, Object>> {
    public static KeyHomeWifi INSTANCE = new KeyHomeWifi();

    private KeyHomeWifi() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        int descriptionStatus;
        HashMap<String, Object> map_homeWifi = new HashMap<String, Object>();
        int flag = data[0] & 0xFF;
        int homeWifi_index = flag & 0xF;
        String mac = ProtocolUtil.bytes2Mac(Arrays.copyOfRange(data, 1, 7), false);
        int rssi = ProtocolUtil.bytes2Int(data[7], true);
        map_homeWifi.put("index", homeWifi_index);
        map_homeWifi.put("mac", mac);
        map_homeWifi.put("rssi", rssi);
        int index = 8;
        int latlngStatus = ProtocolUtil.getbit(flag, 7, 8);
        if (latlngStatus == 1) {
            double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 8, 12));
            double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 12, 16));
            map_homeWifi.put("lat", lat);
            map_homeWifi.put("lng", lng);
            index += 8;
        }
        if ((descriptionStatus = ProtocolUtil.getbit(flag, 6, 7)) == 1) {
            String description = BytesHexStrUtil.bytes2StringByUTF_8(Arrays.copyOfRange(data, index, data.length));
            map_homeWifi.put("describe", description);
        }
        return map_homeWifi;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        int index = Convert.toInt(data.get("index"), 0);
        String mac = Convert.toStr(data.get("mac"), "00:00:00:00:00:00");
        byte rssi = Convert.toByte(data.get("rssi"), (byte)0);
        int isLanLng = Convert.toInt(data.get("isLanLng"), 0);
        double lat = Convert.toDouble(data.get("lat"), 0.0);
        double lng = Convert.toDouble(data.get("lng"), 0.0);
        int isDescribe = Convert.toInt(data.get("isDescribe"), 0);
        String describe = Convert.utf8Str(data.get("describe"));
        int flag = index | isDescribe << 6 | isLanLng << 7;
        byte[] data_homeWifi = new byte[]{(byte)flag};
        data_homeWifi = ArrayUtils.addAll(data_homeWifi, ProtocolUtil.mac2Bytes(mac, false));
        data_homeWifi = ArrayUtils.addAll(data_homeWifi, rssi);
        if (isLanLng == 1) {
            data_homeWifi = ArrayUtils.addAll(data_homeWifi, ProtocolUtil.latlng2Bytes(lat, lng));
        }
        if (isDescribe == 1) {
            data_homeWifi = ArrayUtils.addAll(data_homeWifi, BytesHexStrUtil.string2BytesByUTF_8(describe));
        }
        return data_homeWifi;
    }
}

