/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyHeartRate
implements AnalysisKey<List<Map>> {
    public static KeyHeartRate INSTANCE = new KeyHeartRate();

    private KeyHeartRate() {
    }

    @Override
    public List<Map> encode(byte[] data) {
        ArrayList<Map> ev07b_heart_list = new ArrayList<Map>();
        for (int i = 0; i < data.length; i += 6) {
            HashMap<String, Comparable<Date>> ev07b_heart = new HashMap<String, Comparable<Date>>();
            Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, i, i + 4));
            int heartRate = data[i + 4] & 0xFF;
            int trustLevel = data[i + 5] & 0xFF;
            ev07b_heart.put("dateTime", new Timestamp(dateTime.getTime()));
            ev07b_heart.put("heartRate", Integer.valueOf(heartRate));
            ev07b_heart.put("trustLevel", Integer.valueOf(trustLevel));
            ev07b_heart_list.add(ev07b_heart);
        }
        return ev07b_heart_list;
    }

    @Override
    public byte[] decode(List<Map> dataList) {
        byte[] data_heartRate = null;
        for (Map heartRate : dataList) {
            byte heartRateNo = Convert.toByte(heartRate.get("heartRate"), (byte)0);
            byte trustLevel = Convert.toByte(heartRate.get("trustLevel"), (byte)0);
            byte[] heartRateBytes = ProtocolUtil.dateTime2Bytes(heartRate.get("dateTime"));
            data_heartRate = ArrayUtils.addAll(data_heartRate, heartRateBytes);
            data_heartRate = ArrayUtils.addAll(data_heartRate, heartRateNo, trustLevel);
        }
        return data_heartRate;
    }
}

