/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class KeyHealthData
implements AnalysisKey<Map<String, Object>> {
    public static KeyHealthData INSTANCE = new KeyHealthData();

    private KeyHealthData() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> healthData = new HashMap<String, Object>(3);
        int manufacturerId = data[0] & 0xFF;
        int type = data[1] & 0xFF;
        Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, 2, 6));
        healthData.put("manufacturerId", manufacturerId);
        healthData.put("type", type);
        healthData.put("DateTime", dateTime);
        if (manufacturerId == 1 && type == 1) {
            int heartRate = data[6] & 0xFF;
            int spo2 = data[7] & 0xFF;
            int pi = data[8] & 0xFF;
            healthData.put("heartRate", heartRate);
            healthData.put("spo2", spo2);
            healthData.put("pi", pi);
        } else if (manufacturerId == 1 && type == 2) {
            int systolic = data[6] & 0xFF;
            int diastolic = data[7] & 0xFF;
            int pulse = data[8] & 0xFF;
            healthData.put("systolic", systolic);
            healthData.put("diastolic", diastolic);
            healthData.put("pulse", pulse);
        }
        return healthData;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        int manufacturerId = Convert.toInt(data.get("manufacturerId"), 0);
        int type = Convert.toInt(data.get("type"), 0);
        byte[] dateTimeBytes = ProtocolUtil.dateTime2Bytes(data.get("DateTime"));
        byte[] dataByte = new byte[]{(byte)manufacturerId, (byte)type};
        dataByte = ArrayUtils.addAll(dataByte, dateTimeBytes);
        if (manufacturerId == 1 && type == 1) {
            int heartRate = Convert.toInt(data.get("heartRate"), 0);
            int spo2 = Convert.toInt(data.get("spo2"), 0);
            int pi = Convert.toInt(data.get("pi"), 0);
            dataByte = ArrayUtils.addAll(dataByte, (byte)heartRate, (byte)spo2, (byte)pi);
        } else if (manufacturerId == 1 && type == 2) {
            int systolic = Convert.toInt(data.get("systolic"), 0);
            int diastolic = Convert.toInt(data.get("diastolic"), 0);
            int pulse = Convert.toInt(data.get("pulse"), 0);
            dataByte = ArrayUtils.addAll(dataByte, (byte)systolic, (byte)diastolic, (byte)pulse);
        }
        return dataByte;
    }
}

