/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class KeyGPS
implements AnalysisKey<Map<String, Object>> {
    public static KeyGPS INSTANCE = new KeyGPS();

    private KeyGPS() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        double lat = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 0, 4));
        double lng = ProtocolUtil.bytes2Latlng(Arrays.copyOfRange(data, 4, 8));
        int speed = data[8] & 0xFF | (data[9] & 0xFF) << 8;
        int direction = data[10] & 0xFF | (data[11] & 0xFF) << 8;
        long altitude = ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 12, 14), true);
        int precision = data[14] & 0xFF | (data[15] & 0xFF) << 8;
        int mileage = (int)ProtocolUtil.bytes2Long(Arrays.copyOfRange(data, 16, 20));
        int satellites = data[20] & 0xFF;
        map.put("lat", lat);
        map.put("lng", lng);
        map.put("speed", Float.valueOf(speed));
        map.put("direction", Float.valueOf(direction));
        map.put("altitude", Float.valueOf(altitude));
        map.put("precision", Float.valueOf(precision));
        map.put("mileage", Float.valueOf(mileage));
        map.put("satellites", Float.valueOf(satellites));
        return map;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        double lat = Convert.toDouble(data.get("lat"), 0.0);
        double lng = Convert.toDouble(data.get("lng"), 0.0);
        long speed = Convert.toLong(data.get("speed"), 0L);
        long direction = Convert.toLong(data.get("direction"), 0L);
        double altitude = Convert.toDouble(data.get("altitude"), 0.0);
        long precision = Convert.toLong(data.get("precision"), 0L);
        long mileage = Convert.toLong(data.get("mileage"), 0L);
        byte satellites = Convert.toByte(data.get("satellites"), (byte)0);
        byte[] data_gps = ProtocolUtil.latlng2Bytes(lat, lng);
        data_gps = ArrayUtils.addAll(data_gps, ProtocolUtil.long2Bytes(speed, 2));
        data_gps = ArrayUtils.addAll(data_gps, ProtocolUtil.long2Bytes(direction, 2));
        data_gps = ArrayUtils.addAll(data_gps, ProtocolUtil.long2Bytes((long)altitude, 2));
        data_gps = ArrayUtils.addAll(data_gps, ProtocolUtil.long2Bytes(precision, 2));
        data_gps = ArrayUtils.addAll(data_gps, ProtocolUtil.long2Bytes(mileage, 4));
        data_gps = ArrayUtils.addAll(data_gps, satellites);
        return data_gps;
    }
}

