/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyGMS
implements AnalysisKey<Map<String, Object>> {
    public static KeyGMS INSTANCE = new KeyGMS();

    private KeyGMS() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> map_gsm = new HashMap<String, Object>(2);
        ArrayList gsmList = new ArrayList();
        int MCC = data[0] & 0xFF | (data[1] & 0xFF) << 8;
        int MNC = data[2] & 0xFF;
        int i = 3;
        while (i + 4 < data.length) {
            HashMap<String, Integer> node = new HashMap<String, Integer>(5);
            int RXL = data[i] & 0xFF;
            int LAC = data[i + 1] & 0xFF | (data[i + 2] & 0xFF) << 8;
            int CELLID = data[i + 3] & 0xFF | (data[i + 4] & 0xFF) << 8;
            node.put("mcc", MCC);
            node.put("mnc", MNC);
            node.put("cellId", CELLID);
            node.put("lac", LAC);
            node.put("signal", RXL);
            gsmList.add(node);
            i += 5;
        }
        map_gsm.put("gsmList", gsmList);
        map_gsm.put("gsmType", "2.5G");
        return map_gsm;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        List gsmList = (List)data.get("gsmList");
        int mcc = 0;
        int mnc = 0;
        byte[] data_gsm = new byte[]{};
        for (Map gsm : gsmList) {
            mcc = Convert.toInt(gsm.get("mcc"), mcc);
            mnc = Convert.toInt(gsm.get("mnc"), mnc);
            int cellId = Convert.toInt(gsm.get("cellId"), 0);
            int lac = Convert.toInt(gsm.get("lac"), 0);
            int signal = Convert.toInt(gsm.get("signal"), 0);
            data_gsm = ArrayUtils.addAll(data_gsm, (byte)signal);
            data_gsm = ArrayUtils.addAll(data_gsm, ProtocolUtil.long2Bytes(lac, 2));
            data_gsm = ArrayUtils.addAll(data_gsm, ProtocolUtil.long2Bytes(cellId, 2));
        }
        byte[] mcc_mnc = ProtocolUtil.long2Bytes(mcc, 2);
        mcc_mnc = ArrayUtils.addAll(mcc_mnc, (byte)(mnc & 0xFF));
        return ArrayUtils.addAll(mcc_mnc, data_gsm);
    }
}

