/*
 * Decompiled with CFR 0.152.
 */
package com.tracker.ev07b.service.key;

import com.tracker.ev07b.ProtocolUtil;
import com.tracker.ev07b.service.key.AnalysisKey;
import com.tracker.util.ArrayUtils;
import com.tracker.util.BytesHexStrUtil;
import com.tracker.util.Convert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyEddystone
implements AnalysisKey<Map<String, Object>> {
    public static KeyEddystone INSTANCE = new KeyEddystone();

    private KeyEddystone() {
    }

    @Override
    public Map<String, Object> encode(byte[] data) {
        HashMap<String, Object> ev07b_beacon = new HashMap<String, Object>(3);
        Date dateTime = ProtocolUtil.bytes2DateTime(Arrays.copyOfRange(data, 0, 4));
        String uuId = BytesHexStrUtil.bytesToHexString(Arrays.copyOfRange(data, 4, 6));
        ev07b_beacon.put("dateTime", dateTime);
        ev07b_beacon.put("uuId", uuId);
        ArrayList ev07b_beacon_list = new ArrayList();
        for (int i = 6; i < data.length; i += 18) {
            HashMap<String, Object> beacon = new HashMap<String, Object>(4);
            String namespaceId = BytesHexStrUtil.bytesToHexString(Arrays.copyOfRange(data, i, i + 10));
            String instanceId = BytesHexStrUtil.bytesToHexString(Arrays.copyOfRange(data, i + 10, i + 16));
            int txPower = ProtocolUtil.bytes2Int(data[i + 16], true);
            int rssi = ProtocolUtil.bytes2Int(data[i + 17], true);
            beacon.put("namespaceId", namespaceId);
            beacon.put("instanceId", instanceId);
            beacon.put("txPower", txPower);
            beacon.put("rssi", rssi);
            ev07b_beacon_list.add(beacon);
        }
        ev07b_beacon.put("list", ev07b_beacon_list);
        return ev07b_beacon;
    }

    @Override
    public byte[] decode(Map<String, Object> data) {
        byte[] beaconListBytes = ProtocolUtil.dateTime2Bytes(data.get("dateTime"));
        String uuid = Convert.toStr(data.get("uuId"));
        uuid = ProtocolUtil.strAfterFillZero(uuid, 4);
        beaconListBytes = ArrayUtils.addAll(beaconListBytes, BytesHexStrUtil.hexStringToBytes(uuid));
        byte[] listByte = null;
        List list = (List)data.get("list");
        for (Map beacon : list) {
            String namespaceId = Convert.toStr(beacon.get("namespaceId"));
            namespaceId = ProtocolUtil.strAfterFillZero(namespaceId, 20);
            String instanceId = Convert.toStr(beacon.get("instanceId"));
            instanceId = ProtocolUtil.strAfterFillZero(instanceId, 12);
            byte txPower = Convert.toByte(beacon.get("txPower"), (byte)0);
            byte rssi = Convert.toByte(beacon.get("rssi"), (byte)0);
            listByte = ArrayUtils.addAll(listByte, BytesHexStrUtil.hexStringToBytes(namespaceId));
            listByte = ArrayUtils.addAll(listByte, BytesHexStrUtil.hexStringToBytes(instanceId));
            listByte = ArrayUtils.addAll(listByte, txPower, rssi);
        }
        beaconListBytes = ArrayUtils.addAll(beaconListBytes, listByte);
        return beaconListBytes;
    }
}

